
unit Szetap;

interface

uses
  windows;

{$R UNITS\SZETAP.RES}

const
  SetupResX : longint = 640;
  SetupResY : longint = 480;
  SetupBits : longint = 16;
  SetupFull : boolean = TRUE;

function Setup: Boolean;

implementation

const
  IDD_SETUPDLG = 101;
  IDC_RESOLUTION = 1000;
  IDC_FULLSCREEN = 1001;

  SetupStart : Boolean = FALSE;
  SetupEject : Boolean = FALSE;

var
  Mess: Msg;
  Idx: Longint;

function SetupDlgProc( hDlg: hWnd; Mess, wPar, lPar: LongInt ): Boolean; StdCall; Export;
begin
  SetupDlgProc := FALSE;
  case ( Mess ) of
    WM_COMMAND:
      begin
        case ( wPar and $FFFF ) of
          IDOK:
            begin

               SetupFull := ( SendDlgItemMessage( hDlg, IDC_FULLSCREEN, BM_GETCHECK, 0, 0 ) = BST_CHECKED );

               Idx := SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_GETCURSEL, 0, 0 );
               case ( Idx ) of
                 00: begin  SetupResX := 320;   SetupResY := 240;   SetupBits := 16;  end;
                 01: begin  SetupResX := 400;   SetupResY := 300;   SetupBits := 16;  end;
                 02: begin  SetupResX := 512;   SetupResY := 384;   SetupBits := 16;  end;
                 03: begin  SetupResX := 640;   SetupResY := 480;   SetupBits := 16;  end;
                 04: begin  SetupResX := 800;   SetupResY := 600;   SetupBits := 16;  end;
                 05: begin  SetupResX := 1024;  SetupResY := 768;   SetupBits := 16;  end;
                 06: begin  SetupResX := 320;   SetupResY := 240;   SetupBits := 32;  end;
                 07: begin  SetupResX := 400;   SetupResY := 300;   SetupBits := 32;  end;
                 08: begin  SetupResX := 512;   SetupResY := 384;   SetupBits := 32;  end;
                 09: begin  SetupResX := 640;   SetupResY := 480;   SetupBits := 32;  end;
                 10: begin  SetupResX := 800;   SetupResY := 600;   SetupBits := 32;  end;
                 11: begin  SetupResX := 1024;  SetupResY := 768;   SetupBits := 32;  end;
                 end;

              SetupStart := TRUE;
              SetupEject := TRUE;
              DestroyWindow( hDlg );
              SetupDlgProc := TRUE;
            end;
          IDCANCEL:
            begin
              SetupEject := TRUE;
              DestroyWindow( hDlg );
              SetupDlgProc := TRUE;
            end;
          end;
      end;
    WM_INITDIALOG:
      begin

        SendDlgItemMessage( hDlg, IDC_FULLSCREEN, BM_SETCHECK, BST_CHECKED, 0 );

        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '320x240 16bit' )));
        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '400x300 16bit' )));
        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '512x384 16bit' )));
        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '640x480 16bit' )));
        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '800x600 16bit' )));
        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '1024x768 16bit' )));

        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '320x240 32bit' )));
        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '400x300 32bit' )));
        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '512x384 32bit' )));
        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '640x480 32bit' )));
        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '800x600 32bit' )));
        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_ADDSTRING, 0, longint( pChar( '1024x768 32bit' )));

        SendDlgItemMessage( hDlg, IDC_RESOLUTION, CB_SELECTSTRING, -1, longint( pChar( '640x480 16bit' )));

        ShowWindow( hDlg, SW_SHOW );

        SetupDlgProc := TRUE;

      end;

    end;
end;

function Setup: Boolean;
begin

  if ( CreateDialog( System.MainInstance, IDD_SETUPDLG, 0, DlgProc( @SetupDlgProc )) = 0 ) then
    begin
      MessageBox( 0, 'Failed: CreateDialog().', 'Jajaj!...', MB_ICONERROR or MB_OK );
      Halt;
    end;

  while ( not SetupEject ) do
    begin
      while ( PeekMessage( @Mess, 0, 0, 0, 0 )) do
        begin
          if GetMessage( @Mess, 0, 0, 0 ) then
            begin
              TranslateMessage( Mess );
              DispatchMessage( Mess );
            end else begin
              // Destroy.
              Halt;
            end;
        end;
      WaitMessage;
    end;

  // Get.
  Setup := SetupStart;

end;

begin
end.
