unit p3D_type;


Interface


Type


p3D_material = record
    textname     : string[8];
    transparency : single;
    texture      : longint;
    utile	 : single;
    vtile	 : single;
    end;

p3D_vector = record
    x   : single;
    y   : single;
    z   : single;
     end;

p3D_camera      = record
    fov         : single;
    position    : ^p3D_vector;
    target      : ^p3D_vector;
    roll        : ^single;
     end;

p3D_textcoord = record
        u   : single;
        v   : single;
    end;

p3D_face = record
    a   : longint;
    b   : longint;
    c   : longint;
    end;

p3D_quat = record
    x   : single;
    y   : single;
    z   : single;
    r   : single;
    end;

p3D_object = record
    vertices    : longint;
    vertex      : ^p3D_vector;
    texcoord    : ^p3D_textcoord;
    faces       : longint;
    face        : ^p3D_face;
    poskeys     : boolean;
    position    : ^p3D_vector;
    rotkeys     : boolean;
    rotate      : ^p3D_quat;
    scalekeys   : boolean;
    scale       : ^p3D_vector;
    material    : longint;
    reclight	: boolean;
    envmap      : boolean;
    render	: boolean;
    end;

p3D_scene = record
    keys        : longint;
    materials   : longint;
    material    : ^p3D_material;
    cameras     : longint;
    camera      : ^p3D_camera;
    objects     : longint;
    obj         : ^p3D_object;
    lights      : longint;
        end;

IMPLEMENTATION


end.