//FPCW
Unit P3d;               // p3d v2.1 - added envmap
Interface

uses Windows,p3d_type,Opengl32,GL_sl,GLU_sl,math,zfs;

procedure p3D_load(var scene:p3d_scene;name:string);
procedure p3D_loadtexturesRAW(var scene:p3D_scene);
procedure p3D_loadtextureRAW(filename:String;var texture : longint);
procedure p3D_initopengl;
procedure p3D_ambient(r,g,b:single);
procedure p3D_lightpos(x,y,z:single);
procedure p3D_lightattr(r,g,b,strength:single);
procedure p3D_renderscene(scene:p3d_scene;timer:single);
procedure p3D_rendersceneobject(scene:p3d_scene;timer:single;objnum:longint;alpha:single);
procedure p3d_fog(start,fend,dens,cr,cg,cb:single);
FUNCTION bezier( U, P1, P2, P3, P4: double ): double;


var     alr,alg,alb     : single;       // ambient light color
        xp1,yp1,zp1     : single;       // light position
        lr,lg,lb        : single;       // light color
        lstrength       : single;       // light strength
        p3d_lighton     : boolean;      // isLight ?
        xt,yt,zt        : single;
        xp,yp,zp        : single;
        envanglex       : single;
        envangley       : single;
        envanglez       : single;
        j : longint;
        t : single;
        xb1,xb2,xb3,xb0 : single;
        yb1,yb2,yb3,yb0 : single;
        zb1,zb2,zb3,zb0 : single;
        xad,yad,zad : single;
        scalex,scalez,scaley : single;
        p3d_clearzbuffer : boolean;

IMPLEMENTATION


FUNCTION bezier( U, P1, P2, P3, P4: double ): double;
BEGIN

  Bezier := Sqr( 1-U ) * ( P1*( 1-U ) + 3*(  U  )*( P1 + P2 )) +
            Sqr(  U  ) * ( P4*(  U  ) + 3*( 1-U )*( P4 - P3 ));

END;

FUNCTION TAV (X1,Y1,Z1: SINGLE):SINGLE;
var av : single;
BEGIN
if p3d_lighton then begin
AV :=1-( SQRT(SQR(X1-Xp1)+SQR(Y1-Yp1)+SQR(Z1-Zp1))/lstrength);
if av >1 then av :=1;
if av <0 then av :=0;
tav := av end else tav :=1;
END;



Procedure p3D_load(var scene:p3d_scene;name:string);
Var f : file;
    i : longint;

begin
assign(f,name);
reset(f,1);
blockread(f,scene.keys,4);
blockread(f,scene.materials,4);
getmem(scene.material,sizeof(p3d_material)*scene.materials);
blockread(f,scene.material^,sizeof(p3d_material)*scene.materials);
blockread(f,scene.cameras,4);
getmem(scene.camera,sizeof(p3d_camera)*scene.cameras);
for i := 0 to scene.cameras-1 do
begin
blockread(f,scene.camera[i].fov,4);
getmem(scene.camera[i].position,scene.keys*sizeof(p3d_vector));
getmem(scene.camera[i].target  ,scene.keys*sizeof(p3d_vector));
getmem(scene.camera[i].roll    ,scene.keys*4);
blockread(f,scene.camera[i].position^,sizeof(p3d_vector)*scene.keys);
blockread(f,scene.camera[i].target^  ,sizeof(p3d_vector)*scene.keys);
blockread(f,scene.camera[i].roll^    ,4*scene.keys);
end;
blockread(f,scene.objects,4);
getmem(scene.obj,sizeof(p3d_object)*scene.objects);
for i := 0 to scene.objects-1 do
begin
blockread(f,scene.obj[i].vertices,4);
getmem(scene.obj[i].vertex  ,sizeof(p3d_vector   )*scene.obj[i].vertices);
getmem(scene.obj[i].texcoord,sizeof(p3d_textcoord)*scene.obj[i].vertices);
blockread(f,scene.obj[i].vertex^  ,sizeof(p3d_vector   )*scene.obj[i].vertices);
blockread(f,scene.obj[i].texcoord^,sizeof(p3d_textcoord)*scene.obj[i].vertices);
blockread(f,scene.obj[i].faces,4);
getmem(scene.obj[i].face,sizeof(p3d_face)*scene.obj[i].faces);
blockread(f,scene.obj[i].face^,sizeof(p3d_face)*scene.obj[i].faces);

blockread(f,scene.obj[i].poskeys,1);
if scene.obj[i].poskeys then
        begin
    getmem(scene.obj[i].position,scene.keys*sizeof(p3d_vector));
    blockread(f,scene.obj[i].position^,scene.keys*sizeof(p3d_vector));
    end;

blockread(f,scene.obj[i].rotkeys,1);
if scene.obj[i].rotkeys then
        begin
    getmem(scene.obj[i].rotate,scene.keys*sizeof(p3d_quat));
    blockread(f,scene.obj[i].rotate^,scene.keys*sizeof(p3d_quat));
    end;

blockread(f,scene.obj[i].scalekeys,1);
if scene.obj[i].scalekeys then
        begin
    getmem(scene.obj[i].scale,scene.keys*sizeof(p3d_vector));
    blockread(f,scene.obj[i].scale^,scene.keys*sizeof(p3d_vector));
    end;
blockread(f,scene.obj[i].material,4);
scene.obj[i].reclight := true;
scene.obj[i].envmap := false;
scene.obj[i].render := true;
end;
blockread(f,scene.lights,4);
close(f);
end;

procedure p3D_loadtexturesRAW(var scene:p3D_scene);
var i : longint;
    p : pointer;
    f : file;
begin

for i := 0 to scene.materials-1 do
begin
assign(f,scene.material[i].textname+'.raw');
reset(f,1);
getmem(p,filesize(f));
blockread(f,p^,filesize(f));


glGentextures(1,scene.material[i].texture);
glEnable(GL_TEXTURE_2D);
glBindTexture(GL_TEXTURE_2D,scene.material[i].texture);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
glTexImage2D(GL_TEXTURE_2D,0,3,256,256,0,GL_RGB,GL_UNSIGNED_BYTE,p^);
gluBuild2DMipmaps(GL_TEXTURE_2D, 3, 256,256, GL_RGB, GL_UNSIGNED_BYTE,p^);

freemem(p,filesize(f));
close(f);
end;
end;


procedure p3D_loadtextureRAW(filename:String;var texture : longint);
var i : longint;
    p : pointer;
    f : file;
begin
assign(f,filename);
reset(f,1);
getmem(p,filesize(f));
blockread(f,p^,filesize(f));
glGentextures(1,texture);
glEnable(GL_TEXTURE_2D);
glBindTexture(GL_TEXTURE_2D,texture);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
glTexImage2D(GL_TEXTURE_2D,0,3,256,256,0,GL_RGB,GL_UNSIGNED_BYTE,p^);
gluBuild2DMipmaps(GL_TEXTURE_2D, 3, 256,256, GL_RGB, GL_UNSIGNED_BYTE,p^);
freemem(p,filesize(f));
close(f);
end;




procedure p3D_initopengl;
begin
glClear( $00004100 );
glClearDepth(1);
glDepthFunc(GL_LESS);
glEnable(GL_DEPTH_test);
glhint(gl_polygon_smooth_hint,GL_NICEST);
glhint(gl_perspective_correction_hint,GL_NICEST);
end;

procedure p3D_ambient(r,g,b:single);
begin
alr := r;
alg := g;
alb := b;
end;

procedure p3D_lightpos(x,y,z:single);
begin
xp1 :=x;
yp1 :=y;
zp1 :=z;
end;

procedure p3D_lightattr(r,g,b,strength:single);
begin
lr :=r;
lg :=g;
lb :=b;
lstrength := strength;
end;


procedure p3D_renderscene(scene:p3d_scene;timer:single);
var     i,i2 : longint;
        a,b,c : longint;
        ta,tb,tc : single;
        ut,vt : single;
begin
if p3d_clearzbuffer then glClear( $00004100 );
j := trunc(timer);
t := frac(timer);

xb0:= scene.camera[0].position[j*3].x;
xb1:= scene.camera[0].position[j*3+1].x;
xb2:= scene.camera[0].position[j*3+2].x;
xb3:= scene.camera[0].position[j*3+3].x;
yb0:= scene.camera[0].position[j*3].y;
yb1:= scene.camera[0].position[j*3+1].y;
yb2:= scene.camera[0].position[j*3+2].y;
yb3:= scene.camera[0].position[j*3+3].y;
zb0:= scene.camera[0].position[j*3].z;
zb1:= scene.camera[0].position[j*3+1].z;
zb2:= scene.camera[0].position[j*3+2].z;
zb3:= scene.camera[0].position[j*3+3].z;

  xp := bezier( t, xb0,xb1-xb0,xb3-xb2,xb3);
  yp := bezier( t, yb0,yb1-yb0,yb3-yb2,yb3);
  zp := bezier( t, zb0,zb1-zb0,zb3-zb2,zb3);

xb0:= scene.camera[0].target[j*3].x;
xb1:= scene.camera[0].target[j*3+1].x;
xb2:= scene.camera[0].target[j*3+2].x;
xb3:= scene.camera[0].target[j*3+3].x;
yb0:= scene.camera[0].target[j*3].y;
yb1:= scene.camera[0].target[j*3+1].y;
yb2:= scene.camera[0].target[j*3+2].y;
yb3:= scene.camera[0].target[j*3+3].y;
zb0:= scene.camera[0].target[j*3].z;
zb1:= scene.camera[0].target[j*3+1].z;
zb2:= scene.camera[0].target[j*3+2].z;
zb3:= scene.camera[0].target[j*3+3].z;


  xt := bezier( t, xb0,xb1-xb0,xb3-xb2,xb3);
  yt := bezier( t, yb0,yb1-yb0,yb3-yb2,yb3);
  zt := bezier( t, zb0,zb1-zb0,zb3-zb2,zb3);

glenable(gl_texture_2d);

glMatrixMode(GL_MODELVIEW);
glLoadIdentity;
glMatrixMode(GL_PROJECTION);
glLoadIdentity;
gluPerspective(scene.camera[0].fov,4/3,0.1,1000);
glscalef(0.05,0.05,0.05);
glulookat(xp,yp,zp,xt,yt,zt,0,0,1);


/////////////////////////////////////////////////OBJECTS
/////////////////////////////////////////////////OBJECTS
/////////////////////////////////////////////////OBJECTS


for i2 := 0 to scene.objects-1 do
begin
if (scene.material[scene.obj[i2].material].transparency = 0) and (scene.obj[i2].render)   then begin
                glmatrixmode(gl_texture);
                glloadidentity;

if scene.obj[i2].envmap then
        begin
        glrotatef(envanglex,1,0,0);
        glrotatef(envangley,0,1,0);
        glrotatef(envanglez,0,0,1);
        end;

glBindTexture(GL_TEXTURE_2D,scene.material[scene.obj[i2].material].texture);

  ut := scene.material[scene.obj[i2].material].utile;
  vt := scene.material[scene.obj[i2].material].vtile;

glMatrixMode(GL_MODELVIEW);
glLoadIdentity;
glMatrixMode(GL_PROJECTION);
glLoadIdentity;



xad :=0;yad :=0;zad:=0;

if scene.obj[i2].poskeys then begin

                                xb0:= scene.obj[i2].position[j*3].x;
                                xb1:= scene.obj[i2].position[j*3+1].x;
                                xb2:= scene.obj[i2].position[j*3+2].x;
                                xb3:= scene.obj[i2].position[j*3+3].x;
                                yb0:= scene.obj[i2].position[j*3].y;
                                yb1:= scene.obj[i2].position[j*3+1].y;
                                yb2:= scene.obj[i2].position[j*3+2].y;
                                yb3:= scene.obj[i2].position[j*3+3].y;
                                zb0:= scene.obj[i2].position[j*3].z;
                                zb1:= scene.obj[i2].position[j*3+1].z;
                                zb2:= scene.obj[i2].position[j*3+2].z;
                                zb3:= scene.obj[i2].position[j*3+3].z;
                                xad:= bezier( t, xb0,xb1-xb0,xb3-xb2,xb3);
                                yad:= bezier( t, yb0,yb1-yb0,yb3-yb2,yb3);
                                zad:= bezier( t, zb0,zb1-zb0,zb3-zb2,zb3);
                                glMatrixMode(GL_modelview);
                                gltranslatef(xad,yad,zad);

                              end;
{if scene.obj[i2].scalekeys then begin

                                xb0:= scene.obj[i2].scale[j*3].x;
                                xb1:= scene.obj[i2].scale[j*3+1].x;
                                xb2:= scene.obj[i2].scale[j*3+2].x;
                                xb3:= scene.obj[i2].scale[j*3+3].x;
                                yb0:= scene.obj[i2].scale[j*3].y;
                                yb1:= scene.obj[i2].scale[j*3+1].y;
                                yb2:= scene.obj[i2].scale[j*3+2].y;
                                yb3:= scene.obj[i2].scale[j*3+3].y;
                                zb0:= scene.obj[i2].scale[j*3].z;
                                zb1:= scene.obj[i2].scale[j*3+1].z;
                                zb2:= scene.obj[i2].scale[j*3+2].z;
                                zb3:= scene.obj[i2].scale[j*3+3].z;
                                xad:= bezier( t, xb0,xb1-xb0,xb3-xb2,xb3);
                                yad:= bezier( t, yb0,yb1-yb0,yb3-yb2,yb3);
                                zad:= bezier( t, zb0,zb1-zb0,zb3-zb2,zb3);
                                glMatrixMode(GL_modelview);
                                glscalef(xad,yad,zad);
                              end;}
{if scene.obj[i2].rotkeys then begin


                                xb0:= scene.obj[i2].rotate[j*3].x;
                                xb1:= scene.obj[i2].rotate[j*3+1].x;
                                xb2:= scene.obj[i2].rotate[j*3+2].x;
                                xb3:= scene.obj[i2].rotate[j*3+3].x;
                                yb0:= scene.obj[i2].rotate[j*3].y;
                                yb1:= scene.obj[i2].rotate[j*3+1].y;
                                yb2:= scene.obj[i2].rotate[j*3+2].y;
                                yb3:= scene.obj[i2].rotate[j*3+3].y;
                                zb0:= scene.obj[i2].rotate[j*3].z;
                                zb1:= scene.obj[i2].rotate[j*3+1].z;
                                zb2:= scene.obj[i2].rotate[j*3+2].z;
                                zb3:= scene.obj[i2].rotate[j*3+3].z;

                                wb0:= scene.obj[i2].rotate[j*3].r;
                                wb1:= scene.obj[i2].rotate[j*3+1].r;
                                wb2:= scene.obj[i2].rotate[j*3+2].r;
                                wb3:= scene.obj[i2].rotate[j*3+3].r;

                                xad:= bezier( t, xb0,xb1-xb0,xb3-xb2,xb3);
                                yad:= bezier( t, yb0,yb1-yb0,yb3-yb2,yb3);
                                zad:= bezier( t, zb0,zb1-zb0,zb3-zb2,zb3);
                                rad:= bezier( t, wb0,wb1-wb0,wb3-wb2,wb3);

                                glMatrixMode(GL_modelview);
                                glrotatef(rad*180/pi,yad,xad,zad);

                              end;}


glMatrixMode(GL_PROJECTION);
gluPerspective(scene.camera[0].fov,4/3,0.1,1000);
glscalef(0.05,0.05,0.05);
glulookat(xp,yp,zp,xt,yt,zt,0,0,1);

                                glMatrixMode(GL_modelview);
                                glscalef(scalex,scaley,scalez);


for i := 0 to scene.obj[i2].faces-1 do
begin

  a := scene.obj[i2].face[i].a;
  b := scene.obj[i2].face[i].b;
  c := scene.obj[i2].face[i].c;
 glBegin(GL_POLYGON);

 Ta := TAV(scene.obj[i2].vertex[a].x,scene.obj[i2].vertex[a].Y,scene.obj[i2].vertex[a].z);
 Tb := TAV(scene.obj[i2].vertex[b].x,scene.obj[i2].vertex[b].Y,scene.obj[i2].vertex[b].z);
 Tc := TAV(scene.obj[i2].vertex[c].x,scene.obj[i2].vertex[c].Y,scene.obj[i2].vertex[c].z);

if scene.obj[i2].reclight then GLCOLOR3F(alr+Ta*lr,alg+Ta*lg,alb+Ta*lb) else glcolor3f(1,1,1);


 glTexCoord2f(1-(ut*scene.obj[i2].texcoord[a].u),1-(vt*scene.obj[i2].texcoord[a].v));
 glvertex3f(scene.obj[i2].vertex[a].x,scene.obj[i2].vertex[a].y,scene.obj[i2].vertex[a].z);

if scene.obj[i2].reclight then  GLCOLOR3F(alr+Tb*lr,alg+Tb*lg,alb+Tb*lb) else glcolor3f(1,1,1);


 glTexCoord2f(1-(ut*scene.obj[i2].texcoord[b].u),1-(vt*scene.obj[i2].texcoord[b].v));
 glvertex3f(scene.obj[i2].vertex[b].x,scene.obj[i2].vertex[b].y,scene.obj[i2].vertex[b].z);

if scene.obj[i2].reclight then  GLCOLOR3F(alr+Tc*lr,alg+Tc*lg,alb+Tc*lb) else glcolor3f(1,1,1);

 glTexCoord2f(1-(ut*scene.obj[i2].texcoord[c].u),1-(vt*scene.obj[i2].texcoord[c].v));
 glvertex3f(scene.obj[i2].vertex[c].x,scene.obj[i2].vertex[c].y,scene.obj[i2].vertex[c].z);

 glEnd;

end;
end;
end;
end;


procedure p3D_rendersceneobject(scene:p3d_scene;timer:single;objnum:longint;alpha:single);
var     i,i2 : longint;
        a,b,c : longint;
        ta,tb,tc : single;
        ut,vt : single;
begin
if p3d_clearzbuffer then glClear( $00004100 );
j := trunc(timer);
t := frac(timer);

xb0:= scene.camera[0].position[j*3].x;
xb1:= scene.camera[0].position[j*3+1].x;
xb2:= scene.camera[0].position[j*3+2].x;
xb3:= scene.camera[0].position[j*3+3].x;
yb0:= scene.camera[0].position[j*3].y;
yb1:= scene.camera[0].position[j*3+1].y;
yb2:= scene.camera[0].position[j*3+2].y;
yb3:= scene.camera[0].position[j*3+3].y;
zb0:= scene.camera[0].position[j*3].z;
zb1:= scene.camera[0].position[j*3+1].z;
zb2:= scene.camera[0].position[j*3+2].z;
zb3:= scene.camera[0].position[j*3+3].z;

  xp := bezier( t, xb0,xb1-xb0,xb3-xb2,xb3);
  yp := bezier( t, yb0,yb1-yb0,yb3-yb2,yb3);
  zp := bezier( t, zb0,zb1-zb0,zb3-zb2,zb3);

xb0:= scene.camera[0].target[j*3].x;
xb1:= scene.camera[0].target[j*3+1].x;
xb2:= scene.camera[0].target[j*3+2].x;
xb3:= scene.camera[0].target[j*3+3].x;
yb0:= scene.camera[0].target[j*3].y;
yb1:= scene.camera[0].target[j*3+1].y;
yb2:= scene.camera[0].target[j*3+2].y;
yb3:= scene.camera[0].target[j*3+3].y;
zb0:= scene.camera[0].target[j*3].z;
zb1:= scene.camera[0].target[j*3+1].z;
zb2:= scene.camera[0].target[j*3+2].z;
zb3:= scene.camera[0].target[j*3+3].z;


  xt := bezier( t, xb0,xb1-xb0,xb3-xb2,xb3);
  yt := bezier( t, yb0,yb1-yb0,yb3-yb2,yb3);
  zt := bezier( t, zb0,zb1-zb0,zb3-zb2,zb3);

glenable(gl_texture_2d);

glMatrixMode(GL_MODELVIEW);
glLoadIdentity;
glMatrixMode(GL_PROJECTION);
glLoadIdentity;
gluPerspective(scene.camera[0].fov,4/3,0.1,1000);
glscalef(0.05,0.05,0.05);
glulookat(xp,yp,zp,xt,yt,zt,0,0,1);


/////////////////////////////////////////////////OBJECTS
/////////////////////////////////////////////////OBJECTS
/////////////////////////////////////////////////OBJECTS


for i2 := objnum to objnum do
begin
if scene.material[scene.obj[i2].material].transparency = 0  then begin
                glmatrixmode(gl_texture);
                glloadidentity;

if scene.obj[i2].envmap then
        begin
        glrotatef(envanglex,1,0,0);
        glrotatef(envangley,0,1,0);
        glrotatef(envanglez,0,0,1);
        end;

glBindTexture(GL_TEXTURE_2D,scene.material[scene.obj[i2].material].texture);

  ut := scene.material[scene.obj[i2].material].utile;
  vt := scene.material[scene.obj[i2].material].vtile;

glMatrixMode(GL_MODELVIEW);
glLoadIdentity;
glMatrixMode(GL_PROJECTION);
glLoadIdentity;



xad :=0;yad :=0;zad:=0;

if scene.obj[i2].poskeys then begin

                                xb0:= scene.obj[i2].position[j*3].x;
                                xb1:= scene.obj[i2].position[j*3+1].x;
                                xb2:= scene.obj[i2].position[j*3+2].x;
                                xb3:= scene.obj[i2].position[j*3+3].x;
                                yb0:= scene.obj[i2].position[j*3].y;
                                yb1:= scene.obj[i2].position[j*3+1].y;
                                yb2:= scene.obj[i2].position[j*3+2].y;
                                yb3:= scene.obj[i2].position[j*3+3].y;
                                zb0:= scene.obj[i2].position[j*3].z;
                                zb1:= scene.obj[i2].position[j*3+1].z;
                                zb2:= scene.obj[i2].position[j*3+2].z;
                                zb3:= scene.obj[i2].position[j*3+3].z;
                                xad:= bezier( t, xb0,xb1-xb0,xb3-xb2,xb3);
                                yad:= bezier( t, yb0,yb1-yb0,yb3-yb2,yb3);
                                zad:= bezier( t, zb0,zb1-zb0,zb3-zb2,zb3);
                                glMatrixMode(GL_modelview);
                                gltranslatef(xad,yad,zad);

                              end;
{if scene.obj[i2].scalekeys then begin

                                xb0:= scene.obj[i2].scale[j*3].x;
                                xb1:= scene.obj[i2].scale[j*3+1].x;
                                xb2:= scene.obj[i2].scale[j*3+2].x;
                                xb3:= scene.obj[i2].scale[j*3+3].x;
                                yb0:= scene.obj[i2].scale[j*3].y;
                                yb1:= scene.obj[i2].scale[j*3+1].y;
                                yb2:= scene.obj[i2].scale[j*3+2].y;
                                yb3:= scene.obj[i2].scale[j*3+3].y;
                                zb0:= scene.obj[i2].scale[j*3].z;
                                zb1:= scene.obj[i2].scale[j*3+1].z;
                                zb2:= scene.obj[i2].scale[j*3+2].z;
                                zb3:= scene.obj[i2].scale[j*3+3].z;
                                xad:= bezier( t, xb0,xb1-xb0,xb3-xb2,xb3);
                                yad:= bezier( t, yb0,yb1-yb0,yb3-yb2,yb3);
                                zad:= bezier( t, zb0,zb1-zb0,zb3-zb2,zb3);
                                glMatrixMode(GL_modelview);
                                glscalef(xad,yad,zad);
                              end;}
{if scene.obj[i2].rotkeys then begin


                                xb0:= scene.obj[i2].rotate[j*3].x;
                                xb1:= scene.obj[i2].rotate[j*3+1].x;
                                xb2:= scene.obj[i2].rotate[j*3+2].x;
                                xb3:= scene.obj[i2].rotate[j*3+3].x;
                                yb0:= scene.obj[i2].rotate[j*3].y;
                                yb1:= scene.obj[i2].rotate[j*3+1].y;
                                yb2:= scene.obj[i2].rotate[j*3+2].y;
                                yb3:= scene.obj[i2].rotate[j*3+3].y;
                                zb0:= scene.obj[i2].rotate[j*3].z;
                                zb1:= scene.obj[i2].rotate[j*3+1].z;
                                zb2:= scene.obj[i2].rotate[j*3+2].z;
                                zb3:= scene.obj[i2].rotate[j*3+3].z;

                                wb0:= scene.obj[i2].rotate[j*3].r;
                                wb1:= scene.obj[i2].rotate[j*3+1].r;
                                wb2:= scene.obj[i2].rotate[j*3+2].r;
                                wb3:= scene.obj[i2].rotate[j*3+3].r;

                                xad:= bezier( t, xb0,xb1-xb0,xb3-xb2,xb3);
                                yad:= bezier( t, yb0,yb1-yb0,yb3-yb2,yb3);
                                zad:= bezier( t, zb0,zb1-zb0,zb3-zb2,zb3);
                                rad:= bezier( t, wb0,wb1-wb0,wb3-wb2,wb3);

                                glMatrixMode(GL_modelview);
                                glrotatef(rad*180/pi,yad,xad,zad);

                              end;}


glMatrixMode(GL_PROJECTION);
gluPerspective(scene.camera[0].fov,4/3,0.1,1000);
glscalef(0.05,0.05,0.05);
glulookat(xp,yp,zp,xt,yt,zt,0,0,1);

                                glMatrixMode(GL_modelview);
                                glscalef(scalex,scaley,scalez);


for i := 0 to scene.obj[i2].faces-1 do
begin

  a := scene.obj[i2].face[i].a;
  b := scene.obj[i2].face[i].b;
  c := scene.obj[i2].face[i].c;
 glBegin(GL_POLYGON);

 Ta := TAV(scene.obj[i2].vertex[a].x,scene.obj[i2].vertex[a].Y,scene.obj[i2].vertex[a].z);
 Tb := TAV(scene.obj[i2].vertex[b].x,scene.obj[i2].vertex[b].Y,scene.obj[i2].vertex[b].z);
 Tc := TAV(scene.obj[i2].vertex[c].x,scene.obj[i2].vertex[c].Y,scene.obj[i2].vertex[c].z);

if scene.obj[i2].reclight then GLCOLOR4F(alr+Ta*lr,alg+Ta*lg,alb+Ta*lb,alpha) else glcolor4f(1,1,1,alpha);


 glTexCoord2f(1-(ut*scene.obj[i2].texcoord[a].u),1-(vt*scene.obj[i2].texcoord[a].v));
 glvertex3f(scene.obj[i2].vertex[a].x,scene.obj[i2].vertex[a].y,scene.obj[i2].vertex[a].z);

if scene.obj[i2].reclight then  GLCOLOR4F(alr+Tb*lr,alg+Tb*lg,alb+Tb*lb,alpha) else glcolor4f(1,1,1,alpha);


 glTexCoord2f(1-(ut*scene.obj[i2].texcoord[b].u),1-(vt*scene.obj[i2].texcoord[b].v));
 glvertex3f(scene.obj[i2].vertex[b].x,scene.obj[i2].vertex[b].y,scene.obj[i2].vertex[b].z);

if scene.obj[i2].reclight then  GLCOLOR4F(alr+Tc*lr,alg+Tc*lg,alb+Tc*lb,alpha) else glcolor4f(1,1,1,alpha);

 glTexCoord2f(1-(ut*scene.obj[i2].texcoord[c].u),1-(vt*scene.obj[i2].texcoord[c].v));
 glvertex3f(scene.obj[i2].vertex[c].x,scene.obj[i2].vertex[c].y,scene.obj[i2].vertex[c].z);

 glEnd;

end;
end;
end;
end;


procedure p3d_fog(start,fend,dens,cr,cg,cb : single);
var    fogcolor : array [0..3] of single;
begin

fogcolor[0] := cr;
fogcolor[1] := cg;
fogcolor[2] := cb;
fogcolor[3] := 1;
    glEnable(GL_FOG);
    glfogf(GL_FOG_END,fend);
    glfogf(GL_FOG_START,start);
    glFogi (GL_FOG_MODE, GL_LINEAR);
    glFogfv (GL_FOG_COLOR, fogColor[0]);
    glFogf (GL_FOG_DENSITY, dens);
    glHint (GL_FOG_HINT, GL_DONT_CARE);

end;


begin
p3d_clearzbuffer:= true;
scalex:=1;
scaley:=1;
scalez:=1;
end.