// FPCW -B frsWm.pas

// ==========================================================================
//  TrebleTEST - DirectX Support for FreePascal Compiler.
// --------------------------------------------------------------------------
//  Copyright (C)2000. Fresh!mindworkz.
// ==========================================================================

unit frsWm;
interface

uses
    OpenGL32,
    Windows,
    SysUtils;

const
     wmWindowed = False;
     wmFScreen  = True;
     wm43       = False; // 4:3
     wm169      = True;  // 16:9

const
     wmEscape     : Boolean = False;
     wmFullScreen : Boolean = wmFScreen;
     wmWidth      : DWord   = 0;
     wmHeight     : DWord   = 0;
     wmScRatio    : Boolean = wm43;

var
   hWind : hWND;
   hDCtx : hDC;
   Mess  : Msg;

function  wmCreate( sX, sY, bM : DWord; Sc,FullScreen: Boolean ) : HWnd;
procedure wmDestroy;
procedure wmUpdate;
procedure wmSetViewPort;

procedure wmChangeVideoMode( sX,sY,bpp : DWord );
procedure wmRestoreVideoMode;
procedure wmCreateContext( Wnd : HWND; Bpp : DWord );
procedure wmDestroyContext( Wnd : HWnd );

implementation

uses
    GL_SL;

const
     CDS_FULLSCREEN = 4;

var
   wmHDC         : HDC;
   wmHGL         : HGLRC;
   wmOldExitProc : Pointer;

procedure wmError( Str : PChar );
begin
  wmDestroy();
  MessageBox( 0,Str,PChar( 'Error ...' ),MB_ICONERROR or MB_OK );
  Halt( 1 );
end;

procedure wmExitProc;
begin
  ExitProc:=wmOldExitProc;
  wmDestroy();
end;

procedure wmCreateContext( Wnd : HWND; Bpp : DWord );
var
   Pfd         : PIXELFORMATDESCRIPTOR;
   PixelFormat : LongInt;
   SPF,MC      : LongBool;
begin
  wmHDC:=GetDC( Wnd );

  FillChar( Pfd,SizeOf( Pfd ),0 );
  Pfd.nSize         := SizeOf( Pfd );
  Pfd.nVersion      := 1;
  Pfd.dwFlags       := PFD_SUPPORT_OPENGL OR PFD_DRAW_TO_WINDOW OR PFD_DOUBLEBUFFER;
  Pfd.iPixelType    := PFD_TYPE_RGBA;
  Pfd.cColorBits    := Bpp;
  Pfd.cDepthBits    := Bpp;

  PixelFormat:=ChoosePixelFormat( wmHDC,Pfd );
  If ( PixelFormat = 0 ) then wmError( 'Fail: ChoosePixelFormat.' );
  SPF:=SetPixelFormat( wmHDC,PixelFormat,@Pfd );
  If ( SPF = FALSE ) then wmError( 'Fail: SetPixelFormat.' );
  wmHGL:=wglCreateContext( wmHDC );
  If ( wmHGL = 0 ) then wmError( 'Fail: wglCreateContext.' );
  MC:=wglMakeCurrent( wmHDC,wmHGL );
  If ( MC = FALSE ) then wmError('Fail: wglMakeCurrent.');
end;

procedure wmDestroyContext( Wnd : HWnd );
begin
  if ( wmHDC <> 0 ) then
    begin
      if ( wmHGL <> 0) then
        begin
          wglMakeCurrent( wmHDC,0 );
          wglDeleteContext( wmHGL );
        end;
      ReleaseDC( Wnd,wmHDC );
    end;
  PostQuitMessage( 0 );
end;

function wmGetSizeY : DWord;
begin
  wmGetSizeY:=wmHeight;
  If ( wmScRatio = wm169 ) then wmGetSizeY:=Round( ( 9.0/16.0 )*( wmWidth ) );
end;

function wmGetY : DWord;
begin
  wmGetY:=( wmHeight - wmGetSizeY() ) div 2;
end;

procedure wmChangeVideoMode( sX,sY,bpp : DWord );
var
   DM : DevMode;
begin
  FillChar( DM,0,SizeOf( DM ) );
  DM.dmSize:=SizeOf( DevMode );
  DM.dmPelsWidth:=sX;
  DM.dmPelsHeight:=sY;
  DM.dmBitsPerPel:=bpp;
  DM.dmFields:=DM_PELSWIDTH or DM_PELSHEIGHT or DM_BITSPERPEL;
  ChangeDisplaySettings( DM,CDS_FULLSCREEN );
  wmFullScreen:=True;
end;

procedure wmRestoreVideoMode;
begin
  ChangeDisplaySettings( 0,0 );
  wmFullScreen:=False;
end;

// --------------------------------------------------------------------------

function WindowProc( Wnd: hWnd; Mess, wPar, lPar: LongInt ): LongInt; StdCall; Export;
begin
  WindowProc := 0;
  case ( Mess ) of
    wm_Char:
      begin
        If ( wPar = vk_Escape ) then
          begin
            wmEscape:=True;
            ReleaseDC( hWind, hDCtx );
            hDCtx := 0;
            PostQuitMessage( 0 );
          end;
      end;
    else
      WindowProc:=DefWindowProc( Wnd, Mess, wPar, lPar );
    end;
end;

// --------------------------------------------------------------------------
var
  WC     : WndClass;
  wmType : DWord;

function  wmCreate( sX, sY, bM : DWord; Sc,FullScreen: Boolean ) : HWnd;
begin
  wmScRatio:=Sc;
  wmWidth:=sX;
  wmHeight:=sY;

  WC.Style          := cs_ByteAlignClient;
  WC.lpfnWndProc    := WndProc( @WindowProc );
  WC.hInstance      := System.MainInstance;
  WC.hCursor        := LoadCursor( 0, IDC_Arrow );
  WC.hIcon          := LoadIcon( 0, IDI_Application );
  WC.hbrBackGround  := GetStockObject( BLACK_BRUSH );
  WC.lpszClassName  := 'Frsh!wndwsstm';
  WC.lpszMenuName   := nil;
  WC.cbClsExtra     := 0;
  WC.cbWndExtra     := 0;

  if ( RegisterClass( WC ) = 0 ) then
    begin
      wmError( 'Fail: RegisterClass().' );
      Exit;
    end;
  wmType:=WS_VISIBLE or WS_POPUP;
  If ( not FullScreen ) then wmType:=wmType or WS_OVERLAPPEDWINDOW;
  hWind:=CreateWindowEx( 0,'Frsh!wndwsstm',Pchar( 'fresh!mindworkz' ),wmType,
    0,0,sX,sY,0,0,System.MainInstance,nil );

  if ( hWind = 0 ) then
    begin
      wmError( 'Fail: CreateWindowEx().' );
      Exit;
    end;

  ShowWindow( hWind, SW_SHOW ); // CmdShow
  UpdateWindow( hWind );
  SetFocus( hWind );

  ShowCursor( FALSE );
  hDCtx := GetDC( hWind );

  wmCreateContext( hWind,bM );
  glViewport( 0,wmGetY(),wmWidth,wmGetSizeY() );
  If ( FullScreen ) then wmChangeVideoMode( sX,sY,bM );
  wmCreate:=hWind;
end;

procedure wmDestroy;
begin
  if ( wmFullScreen ) then wmRestoreVideoMode();
  wmDestroyContext( hWind );
  ShowCursor( True );
end;

procedure wmUpdate;
begin
  SwapBuffers( wmHDC );
end;

procedure wmSetViewPort;
begin
  glViewport( 0,wmGetY(),wmWidth,wmGetSizeY() );
end;

begin
  wmOldExitProc:=ExitProc;
  ExitProc:=@wmExitProc;
end.