
// --- FPCW -----------------------------------------------------------------
//
// --------------------------------------------------------------------------

unit frsBass;
interface

uses
    Strings,
    Windows;

const
     bassNo3D = 0;
     bassA3D  = 1;
     bassEAX  = 2;

const
     bassDevices : Byte = 0;

type
    bassDevice = record
                   Name : String;
                   Typ  : Byte;
                 end;

var
   bassDevicesArray : array[0..5] of BassDevice;

procedure bassInit( Handle : Integer;SmpFreq : DWord;FileName : String;hWindow : HWnd );
procedure bassDone;
procedure bassDetectDevices( hWindow : HWnd );
procedure bassSetVolume( V : Integer );
procedure bassFadeOut;
function  bassGetMusicLength : DWord;
function  bassPlay : Boolean;
function  bassGetMaxDevice( hWindow : HWnd ) : DWord;
function  bassGetPosition : DWord;
function  bassGetLevel : DWord;

implementation

uses
    FrsZip,
    Bass;

var
   Zaj         : HMUSIC;

procedure bassInit( Handle : Integer;SmpFreq : DWord;FileName : String;hWindow : HWnd );
var
   FF     : File;
   Buffer : Pointer;
begin
  if ( not BASS_Init( Handle,SmpFreq,BASS_MUSIC_3D or BASS_MUSIC_RAMPS,hWindow ) ) then
     begin
      MessageBox( 0,'BASS initialization error.',nil,mb_Ok );
      Halt( 1 );
     end;
  BASS_Start();
  Buffer:=zipRead( FileName );
  Zaj:=BASS_MusicLoad( True,Buffer,0,0,BASS_MUSIC_RAMPS or BASS_MUSIC_3D );
//  WriteLn( Log,'BASS error code: ',BASS_ErrorGetCode() );
  If ( Zaj = 0 ) then
     begin
      MessageBox( 0,'BASS can''t music load file.',nil,mb_Ok );
      Halt( 1 );
     end;
  FreeMem( Buffer,zipFileSize( FileName ) );
  BASS_MusicSetAmplify( Zaj,50 );
  BASS_SetGlobalVolumes( 100,-1,-1 )
end;

procedure bassDetectDevices( hWindow : HWnd );
begin
  bassDevices:=bassGetMaxDevice( hWindow );
end;

function bassGetMusicLength : DWord;
begin
  bassGetMusicLength:=BASS_MusicGetLength( Zaj );
end;

function bassPlay : Boolean;
begin
  bassPlay:=BASS_MusicPlay( Zaj );
end;

procedure bassDone;
begin
  bassFadeOut();
  BASS_MusicFree( Zaj );
  BASS_Stop();
  BASS_Free();
end;

function bassGetMaxDevice( hWindow : HWnd ) : DWord;
var
   C   : Integer;
   S   : PChar;
   D   : DWord;
   F1,
   F2,
   F3  : Single;
begin
  C:=0;
  while ( BASS_GetDeviceDescription( C,S ) ) do
   begin
     bassDevicesArray[C].Name:=StrPas( S );
     If ( not BASS_Init( C,44100,BASS_DEVICE_A3D,hWindow ) ) then
      begin
       If ( not BASS_Init( C,44100,BASS_DEVICE_3D,hWindow ) ) then
        begin
         // no 3D support
         bassDevicesArray[C].Typ:=bassNo3D;
         bassDevicesArray[C].Name:=bassDevicesArray[C].Name + ' [No3D]';
        end;
      end
       else
        begin
         // it has A3D
         bassDevicesArray[C].Typ:=bassA3D;
         bassDevicesArray[C].Name:=bassDevicesArray[C].Name + ' [A3d]';
        end;
     if ( BASS_GetEAXParameters( D,F1,F2,F3 ) ) then
      begin
       // it has EAX
       bassDevicesArray[C].Typ:=bassEAX;
       bassDevicesArray[C].Name:=bassDevicesArray[C].Name + ' [EAX]';
      end;
     Inc( C );
     BASS_Free();
   end;
  bassGetMaxDevice:=C;
end;

function bassGetPosition : DWord;
begin
  bassGetPosition:=BASS_ChannelGetPosition( Zaj );
end;

function bassGetLevel : DWord;
begin
  bassGetLevel:=BASS_ChannelGetLevel( Zaj );
end;

procedure bassSetVolume( V : Integer );
begin
  BASS_SetGlobalVolumes( V,-1,-1 )
end;

procedure bassFadeOut;
var
   J,
   K,
   I  : DWord;
begin
  BASS_GetGlobalVolumes( I,J,K );
  while ( I > 0 ) do
    begin
      BASS_SetGlobalVolumes( I,-1,-1 );
      Dec( I,4 );
      Sleep( 50 );
    end;
end;

end.