
unit as_type;

// ==========================================================================
//  autospace3d - version 0.90 / o1.o8.2ooo
//  freepascal (clax) keyframing & (opengl) 3d engine - type definitions.
// --------------------------------------------------------------------------
//  copyright (c)2ooo. remage / fresh!mindworkz.
// --------------------------------------------------------------------------

interface

// ==========================================================================

const
  as_epsilon : single = 0.000001;

// --- error codes ----------------------------------------------------------

  as_err_ok               = 0;        // no error.
  as_err_out_of_memory    = 1;        // out of memory.
  as_err_file_not_found   = 2;        // file not found.
  as_err_invalid_file     = 3;        // invalid (corrupted?) file.
  as_err_invalid_version  = 4;        // unsupported version.
  as_err_invalid_format   = 5;        // unsupported file format.
  as_err_invalid_frame    = 6;        // invalid frame number.
  as_err_invalid_name     = 7;        // invalid object name.
  as_err_no_keyframes     = 8;        // no keyframer data.
  as_err_no_scene_loaded  = 9;        // no scene loaded.
  as_err_null_pointer     = 10;       // null pointer assignment.
  as_err_invalid_param    = 11;       // invalid parameter.
  as_err_invalid_spline   = 12;       // less than 2 keys in spline.
  as_err_singular_matrix  = 13;       // can't inverse singular matrix.
  as_err_invalid_object   = 14;       // invalid object id / name.
  as_err_object_exists    = 15;       // object already exists.
  as_err_invalid_keyid    = 16;       // invalid keyframer node id.
  as_err_undefined        = 255;      // internal error.

// --- object types ---------------------------------------------------------

  as_obj_camera           = $01;      // camera.
  as_obj_light            = $02;      // light.
  as_obj_object           = $04;      // object.
  as_obj_material         = $08;      // material.
  as_obj_ambient          = $10;      // ambient.

// --- track types ----------------------------------------------------------

  as_trk_camera           = $01;      // camera track.
  as_trk_camtarget        = $02;      // camera target track.
  as_trk_omnilight        = $04;      // omnilight track.
  as_trk_spotlight        = $08;      // spotlight track.
  as_trk_spottarget       = $10;      // spotlight target track.
  as_trk_object           = $20;      // object track.
  as_trk_ambient          = $40;      // ambient track.
  
// --- key types ------------------------------------------------------------
  
  as_key_position         = 1;        // position key.  
  as_key_rotate           = 2;        // rotate key.
  as_key_scale            = 3;        // scale key.
  as_key_fov              = 4;        // fov key.
  as_key_roll             = 5;        // roll key.
  as_key_color            = 6;        // color key.
  as_key_morph            = 7;        // morph key.
  as_key_hide             = 8;        // hide key.
  
// --- keyframer flags ------------------------------------------------------

  as_hierarchy            = $01;      // hierarchical transformations.
  as_calcnormal           = $02;      // calculate object normals.
  as_slerp                = $04;      // quaternion spherical interpolation.
  as_transform            = $08;      // internal transformations.
  as_internalmorph        = $10;      // internal object morph.
  as_morph_lerpnormal     = $20;      // morph: lerp normals.
  as_morph_calcnormal     = $40;      // morph: recalculate normals.

// --- material flags -------------------------------------------------------

  as_mat_flat             = $00;      // flat shading.
  as_mat_gouraud          = $01;      // gouraud shading.
  as_mat_phong            = $02;      // phong shading.
  as_mat_metal            = $03;      // metal shading.

  as_mat_twosided         = $04;      // two sided.
  as_mat_soften           = $08;      // soften.
  as_mat_wireframe        = $10;      // wireframe rendering.
  as_mat_transparent      = $20;      // transparency add.

// --- map flags ------------------------------------------------------------

  as_map_mirror           = $01;      // mirror.
  as_map_negative         = $02;      // negative.

// --- face flags -----------------------------------------------------------

  as_face_visible         = $04;      // face visible (backface cull).
  as_face_wrapu           = $08;      // texture wrapping (u). (3DS!COMPATIBLE)
  as_face_wrapv           = $10;      // texture wrapping (v). (3DS!COMPATIBLE)
  
// --- object flags ---------------------------------------------------------

  as_obj_hidden           = $01;      // object is hidden.
  as_obj_chidden          = $02;      // object is always hidden.
  as_obj_dummy            = $04;      // dummy object.
  as_obj_morph            = $08;      // object is morphing.
  
// --- light flags ----------------------------------------------------------

  as_lit_omni             = 1;        // light is omnilight.
  as_lit_spot             = 2;        // light is spotlight.
  
// --- track flags ----------------------------------------------------------

  as_trk_repeat           = $01;      // repeat track.
  as_trk_loop             = $02;      // loop track.
  
// ==========================================================================

type 

  psingle = ^single;

// --- matrix ---------------------------------------------------------------

  as_pmatrix = ^as_matrix;
  as_matrix = array[ 0..2, 0..3 ] of single;
  
// --- color ----------------------------------------------------------------

  as_pcolor = ^as_color;
  as_color = record
    r, g, b : single;
    end;

// --- vector ---------------------------------------------------------------

  as_pvector = ^as_vector;    
  as_vector = record
    x, y, z : single;
    end;
    
// --- quatern --------------------------------------------------------------

  as_pquatern = ^as_quatern;
  as_quatern = record
    x, y, z, w : single;
    end;
    
// --- morph ----------------------------------------------------------------

  as_pmorph = ^as_morph;
  as_morph = record
    from, into : longint;
    alpha : single;
    end;
    
// --- map ------------------------------------------------------------------

  as_pmap = ^as_map;
  as_map = record
    fname : string[64];
    flags : longint;
    uscl, vscl : single;
    uofs, vofs : single;
    angle : single;
    end;

// --- material -------------------------------------------------------------

  as_pmaterial = ^as_material;
  as_material = record
    fname : string[64];
    id, shading, flags : longint;
    ambient, diffuse, specular : as_color;
    shininess, shin_strength : single;
    transparency, trans_falloff : single;
    refblur, self_illum : single;
    texture, bump, reflection : as_map;
    end;
    
// --- vertex ---------------------------------------------------------------

  as_pvertex = ^as_vertex;
  as_vertex = record
    vert, pvert : as_vector;
    norm, pnorm : as_vector;
    u, v : single;
    end;
    
// --- face -----------------------------------------------------------------

  as_pface = ^as_face;
  as_face = record
    a, b, c, flags, mat : longint;
    pa, pb, pc : as_pvertex;
    pmat : as_pmaterial;
    norm, pnorm : as_vector;
    end;
    
// --- light ----------------------------------------------------------------

  as_plight = ^as_light;
  as_light = record
    fname : string[64];
    id, parent1, parent2, flags : longint;
    position, target : as_vector;
    roll, hotspot, falloff : single;
    color : as_color;
    end;
  
// --- camera ---------------------------------------------------------------

  as_pcamera = ^as_camera;
  as_camera = record
    fname : string[64];
    id, parent1, parent2 : longint;
    position, target : as_vector;
    fov, roll, aspectratio : single;
    sizex, sizey, perspx, perspy : single;
    matrix : as_matrix;
    end;
  
// --- object ---------------------------------------------------------------

  as_pobject = ^as_object;
  as_object = record
    fname : string[64];
    id, parent, flags : longint;
    numverts, numfaces : longint;
    verts : as_pvertex;
    faces : as_pface;
    pivot, translate, scale : as_vector;
    rotate : as_quatern;
    morph : as_morph;
    matrix : as_matrix;
    end;
    
// --- ambient --------------------------------------------------------------

  as_pambient = ^as_ambient;
  as_ambient = record
    fname : string[64];
    id : longint;
    color : as_color;
    end;
    
// --- world node -----------------------------------------------------------

  as_pwnode = ^as_wnode;
  as_wnode = record
    typ: longint;
    obj: pointer;
    next, prev: as_pwnode;
    end;
    
// --- key data -------------------------------------------------------------
{
  as_pkdata = ^as_kdata;
  as_kdata = record
    _int: longint;
    _float: single;
    _vect: as_vector;
    _quat: as_quatern;
    end;
}  
  as_pkey = ^as_key;
  as_key = record
    frame, tens, bias, cont : single;
    easeto, easefrom : single;
    val : as_quatern;
    dsa, dsb, dsc, dsd, dda, ddb, ddc, ddd : single;
    ds, dd, qa : as_quatern;
    next, prev : as_pkey;
    end;
    
  as_ptrack = ^as_track;
  as_track = record
    flags, numkeys : longint;
    frames : single;
    keys, last : as_pkey;
    end;
    
  as_pcameratrack = ^as_cameratrack;
  as_cameratrack = record
    position, fov, roll : as_ptrack;
    end;
    
  as_pcamtargettrack = ^as_camtargettrack;
  as_camtargettrack = record
    position : as_ptrack;
    end;
    
  as_pomnilighttrack = ^as_omnilighttrack;
  as_omnilighttrack = record
    position, color : as_ptrack;
    end;
    
  as_pspotlighttrack = ^as_spotlighttrack;
  as_spotlighttrack = record
    position, color, roll, hotspot, falloff : as_ptrack;
    end;
  
  as_pspottargettrack = ^as_spottargettrack;
  as_spottargettrack = record
    position : as_ptrack;
    end;
    
  as_pobjecttrack = ^as_objecttrack;
  as_objecttrack = record
    translate, scale, rotate, morph, hide : as_ptrack;
    end;
    
  as_pambienttrack = ^as_ambienttrack;
  as_ambienttrack = record
    color : as_ptrack;
    end;
    
  as_pknode = ^as_knode;
  as_knode = record
    typ, id : longint;
    track, obj : pointer;
    parent, child, brother, prev, next : as_pknode;
    end;
    
  as_pscene = ^as_scene;
  as_scene = record
    framestart, frameend, frame : single;
    keyfr, ktail : as_pknode;
    world, wtail : as_pwnode;
    end;
    
implementation

end.