
unit as_splin;

// ==========================================================================
//  autospace3d - version 0.90 / o1.o8.2ooo
//  freepascal (clax) keyframer & (opengl) 3d engine - spline interpolation.
// --------------------------------------------------------------------------
//  copyright (c)2ooo. remage / fresh!mindworkz.
// --------------------------------------------------------------------------
//  kochanek-bartels spline sub-type of hermit curve (siggraph'84).
//  correct quaternion interpolation is still missing.
// --------------------------------------------------------------------------

interface

uses 
  math, as_type, as_vect, as_matr, as_quat;

function as_spline_init( track: as_ptrack ): longint;
function as_spline_initrot( track: as_ptrack ): longint;

function as_spline_getkeyfloat( var out: single; track: as_ptrack; frame: single ): longint;
function as_spline_getkeyvect( var out: as_vector; track: as_ptrack; frame: single ): longint;
function as_spline_getkeyquat( var out: as_quatern; track: as_ptrack; frame: single ): longint;

// ==========================================================================

implementation

// --------------------------------------------------------------------------

procedure as_compelementderiv( pp, p, pn: single; var ds, dd: single; ksm, ksp, kdm, kdp: single );
var
  delm, delp: single;
begin
  delm := p - pp;
  delp := pn - p;
  ds := ksm * delm + ksp * delp;
  dd := kdm * delm + kdp * delp;
end;

// --------------------------------------------------------------------------

procedure as_compderiv( var keyp, key, keyn: as_pkey );
var
  tm, cm, cp, bm, bp, tmcm, tmcp: single;
  ksm, ksp, kdm, kdp: single;
  dt, fp, fn, c: single;
begin
  dt := 0.5 * ( keyn^.frame - keyp^.frame );
  fp := ( key^.frame - keyp^.frame ) / dt;
  fn := ( keyn^.frame - key^.frame ) / dt;
  c := abs( key^.cont );
  fp := fp + c - c * fp;
  fn := fn + c - c * fn;
  tm := 0.5 * ( 1.0 - key^.tens );
  cm := 1.0 - key^.cont;
  cp := 2.0 - cm;
  bm := 1.0 - key^.bias;
  bp := 2.0 - bm;
  tmcm := tm * cm;
  tmcp := tm * cp;
  ksm := tmcm * bp * fp; 
  ksp := tmcp * bm * fp;
  kdm := tmcp * bp * fn;
  kdp := tmcm * bm * fn;
  as_compelementderiv( keyp^.val.w, key^.val.w, keyn^.val.w, key^.dsa, key^.dda, ksm, ksp, kdm, kdp );
  as_compelementderiv( keyp^.val.x, key^.val.x, keyn^.val.x, key^.dsb, key^.ddb, ksm, ksp, kdm, kdp );
  as_compelementderiv( keyp^.val.y, key^.val.y, keyn^.val.y, key^.dsc, key^.ddc, ksm, ksp, kdm, kdp );
  as_compelementderiv( keyp^.val.z, key^.val.z, keyn^.val.z, key^.dsd, key^.ddd, ksm, ksp, kdm, kdp );
end;

// --------------------------------------------------------------------------

procedure as_compderivfirst( var key, keyn, keynn: as_pkey );
var
  f20, f10, v20, v10: single;
begin
  f20 := keynn^.frame - key^.frame;
  f10 := keyn^.frame - key^.frame;
  v20 := keynn^.val.w - key^.val.w;
  v10 := keyn^.val.w - key^.val.w;
  key^.dda := ( 1.0 - key^.tens ) * ( v20 * ( 0.25 - f10 / ( 2*f20 )) + ( v10 - v20/2 ) * 3/2 + v20/2 );
  v20 := keynn^.val.x - key^.val.x;
  v10 := keyn^.val.x - key^.val.x;
  key^.ddb := ( 1.0 - key^.tens ) * ( v20 * ( 0.25 - f10 / ( 2*f20 )) + ( v10 - v20/2 ) * 3/2 + v20/2 );
  v20 := keynn^.val.y - key^.val.y;
  v10 := keyn^.val.y - key^.val.y;
  key^.ddc := ( 1.0 - key^.tens ) * ( v20 * ( 0.25 - f10 / ( 2*f20 )) + ( v10 - v20/2 ) * 3/2 + v20/2 );
  v20 := keynn^.val.z - key^.val.z;
  v10 := keyn^.val.z - key^.val.z;
  key^.ddd := ( 1.0 - key^.tens ) * ( v20 * ( 0.25 - f10 / ( 2*f20 )) + ( v10 - v20/2 ) * 3/2 + v20/2 );
end;

// --------------------------------------------------------------------------

procedure as_compderivlast( var keypp, keyp, key: as_pkey );
var
  f20, f10, v20, v10: single;
begin
  f20 := key^.frame - keypp^.frame;
  f10 := key^.frame - keyp^.frame;
  v20 := key^.val.w - keypp^.val.w;
  v10 := key^.val.w - keyp^.val.w;
  key^.dsa := ( 1.0 - key^.tens ) * ( v20 * ( 0.25 - f10 / ( 2*f20 )) + ( v10 - v20/2 ) * 3/2 + v20/2 );
  v20 := key^.val.x - keypp^.val.x;
  v10 := key^.val.x - keyp^.val.x;
  key^.dsb := ( 1.0 - key^.tens ) * ( v20 * ( 0.25 - f10 / ( 2*f20 )) + ( v10 - v20/2 ) * 3/2 + v20/2 );
  v20 := key^.val.y - keypp^.val.y;
  v10 := key^.val.y - keyp^.val.y;
  key^.dsc := ( 1.0 - key^.tens ) * ( v20 * ( 0.25 - f10 / ( 2*f20 )) + ( v10 - v20/2 ) * 3/2 + v20/2 );
  v20 := key^.val.z - keypp^.val.z;
  v10 := key^.val.z - keyp^.val.z;
  key^.dsd := ( 1.0 - key^.tens ) * ( v20 * ( 0.25 - f10 / ( 2*f20 )) + ( v10 - v20/2 ) * 3/2 + v20/2 );
end;

// --------------------------------------------------------------------------

procedure as_compderivloopfirst( var keyp, key, keyn: as_pkey; lf: single );
var
  tm, cm, cp, bm, bp, tmcm, tmcp: single;
  ksm, ksp, kdm, kdp: single;
  dt, fp, fn, c: single;
begin
  dt := 0.5 * ( keyn^.frame - keyp^.frame + lf );
  fp := ( key^.frame - keyp^.frame + lf ) / dt;
  fn := ( keyn^.frame - key^.frame ) / dt;
  c := abs( key^.cont );
  fp := fp + c - c * fp;
  fn := fn + c - c * fn;
  tm := 0.5 * ( 1.0 - key^.tens );
  cm := 1.0 - key^.cont;
  cp := 2.0 - cm;
  bm := 1.0 - key^.bias;
  bp := 2.0 - bm;
  tmcm := tm * cm;
  tmcp := tm * cp;
  ksm := tmcm * bp * fp; 
  ksp := tmcp * bm * fp;
  kdm := tmcp * bp * fn;
  kdp := tmcm * bm * fn;
  as_compelementderiv( keyp^.val.w, key^.val.w, keyn^.val.w, key^.dsa, key^.dda, ksm, ksp, kdm, kdp );
  as_compelementderiv( keyp^.val.x, key^.val.x, keyn^.val.x, key^.dsb, key^.ddb, ksm, ksp, kdm, kdp );
  as_compelementderiv( keyp^.val.y, key^.val.y, keyn^.val.y, key^.dsc, key^.ddc, ksm, ksp, kdm, kdp );
  as_compelementderiv( keyp^.val.z, key^.val.z, keyn^.val.z, key^.dsd, key^.ddd, ksm, ksp, kdm, kdp );
end;

// --------------------------------------------------------------------------

procedure as_compderivlooplast( var keyp, key, keyn: as_pkey; lf: single );
var
  tm, cm, cp, bm, bp, tmcm, tmcp: single;
  ksm, ksp, kdm, kdp: single;
  dt, fp, fn, c: single;
begin
  dt := 0.5 * ( keyn^.frame - keyp^.frame + lf );
  fp := ( key^.frame - keyp^.frame ) / dt;
  fn := ( keyn^.frame - key^.frame + lf ) / dt;
  c := abs( key^.cont );
  fp := fp + c - c * fp;
  fn := fn + c - c * fn;
  tm := 0.5 * ( 1.0 - key^.tens );
  cm := 1.0 - key^.cont;
  cp := 2.0 - cm;
  bm := 1.0 - key^.bias;
  bp := 2.0 - bm;
  tmcm := tm * cm;
  tmcp := tm * cp;
  ksm := tmcm * bp * fp; 
  ksp := tmcp * bm * fp;
  kdm := tmcp * bp * fn;
  kdp := tmcm * bm * fn;
  as_compelementderiv( keyp^.val.w, key^.val.w, keyn^.val.w, key^.dsa, key^.dda, ksm, ksp, kdm, kdp );
  as_compelementderiv( keyp^.val.x, key^.val.x, keyn^.val.x, key^.dsb, key^.ddb, ksm, ksp, kdm, kdp );
  as_compelementderiv( keyp^.val.y, key^.val.y, keyn^.val.y, key^.dsc, key^.ddc, ksm, ksp, kdm, kdp );
  as_compelementderiv( keyp^.val.z, key^.val.z, keyn^.val.z, key^.dsd, key^.ddd, ksm, ksp, kdm, kdp );
end;

// --------------------------------------------------------------------------

procedure as_compderivtwo( var key, keyn: as_pkey );
begin
  key^.dsa := 0.0;
  key^.dsb := 0.0;
  key^.dsc := 0.0;
  key^.dsd := 0.0;
  key^.dda := ( keyn^.val.w - key^.val.w ) * ( 1.0 - key^.tens );
  key^.ddb := ( keyn^.val.x - key^.val.x ) * ( 1.0 - key^.tens );
  key^.ddc := ( keyn^.val.y - key^.val.y ) * ( 1.0 - key^.tens );
  key^.ddd := ( keyn^.val.z - key^.val.z ) * ( 1.0 - key^.tens );
  keyn^.dsa := ( keyn^.val.w - key^.val.w ) * ( 1.0 - keyn^.tens );
  keyn^.dsb := ( keyn^.val.x - key^.val.x ) * ( 1.0 - keyn^.tens );
  keyn^.dsc := ( keyn^.val.y - key^.val.y ) * ( 1.0 - keyn^.tens );
  keyn^.dsd := ( keyn^.val.z - key^.val.z ) * ( 1.0 - keyn^.tens );
  keyn^.dda := 0.0;
  keyn^.ddb := 0.0;
  keyn^.ddc := 0.0;
  keyn^.ddd := 0.0;
end;

// --------------------------------------------------------------------------

procedure as_compab( keyp, key, keyn: as_pkey );
var
  qprev, qnext, q, qp, qm, qa, qb, qae, qbe: as_quatern;
  _qa, _qb, _qc, _qaa, _qab, _qac: as_quatern;
  tm, cm, cp, bm, bp, tmcm, tmcp, ksm, ksp, kdm ,kdp: single;
  dt, fp, fn, c: single;
  i: longint;
begin
  as_quat_copy( _qab, key^.val );
  as_quat_copy( _qb, key^.qa );
  if ( keyp <> NIL ) then
    begin
      as_quat_copy( _qaa, keyp^.val );
      as_quat_copy( _qa, keyp^.qa );
    end;
  if ( keyn <> NIL ) then
    begin
      as_quat_copy( _qac, keyn^.val );
      as_quat_copy( _qc, keyn^.qa );
    end;
  if ( keyp <> NIL ) then
    begin
      if ( abs( _qab.w - _qaa.w ) > 2*3.1415926536 - as_epsilon ) then
        begin
          as_quat_copy( q, _qab );
          q.w := 0.0;
          as_quat_log( qm, q );
        end else begin
          as_quat_copy( qprev, _qa );
          if ( as_quat_dotunit( qprev, _qb ) < 0.0 ) then
            as_quat_negate( qprev, qprev );
          as_quat_lndif( qm, qprev, _qb );
        end;
    end;
  if ( keyn <> NIL ) then
    begin
      if ( abs( _qac.w - _qab.w ) > 2*3.1415926536 - as_epsilon ) then
        begin
          as_quat_copy( q, _qac );
          q.w := 0.0;
          as_quat_log( qp, q );
        end else begin
          as_quat_copy( qnext, _qc );
          if ( as_quat_dotunit( qnext, _qb ) < 0.0 ) then
            as_quat_negate( qnext, qnext );
          as_quat_lndif( qp, _qb, qnext );
        end;
    end;
  if ( keyp = NIL ) then
    as_quat_copy( qm, qp );
  if ( keyn = NIL ) then
    as_quat_copy( qp, qm );
  fp := 1.0;
  fn := 1.0;
  if (( keyp <> NIL ) and ( keyn <> NIL )) then
    begin
      dt := 0.5 * ( keyn^.frame - keyp^.frame );
      fp := ( key^.frame - keyp^.frame ) / dt;
      fn := ( keyn^.frame - key^.frame ) / dt;
      c := abs( key^.cont );
      fp := fp + c - c*fp;
      fn := fn + c - c*fn;
    end;
  tm := 0.5 * ( 1.0 - key^.tens );
  cm := 1.0 - key^.cont;
  cp := 2.0 - cm;
  bm := 1.0 - key^.bias;
  bp := 2.0 - bm;  
  tmcm := tm * cm;
  tmcp := tm * cp;
  ksm := 1.0 - tmcm * bp * fp;
  ksp := - tmcp * bm * fp;
  kdm := tmcp * bp * fn;
  kdp := tmcm * bm * fn - 1.0;
  qa.x := 0.5 * ( kdm * qm.x + kdp * qp.x );
  qb.x := 0.5 * ( ksm * qm.x + ksp * qp.x );
  qa.y := 0.5 * ( kdm * qm.y + kdp * qp.y );
  qb.y := 0.5 * ( ksm * qm.y + ksp * qp.y );
  qa.z := 0.5 * ( kdm * qm.z + kdp * qp.z );
  qb.z := 0.5 * ( ksm * qm.z + ksp * qp.z );
  qa.w := 0.5 * ( kdm * qm.w + kdp * qp.w );
  qb.w := 0.5 * ( ksm * qm.w + ksp * qp.w );
  as_quat_exp( qae, qa );
  as_quat_exp( qbe, qb );
  as_quat_mul( key^.ds, _qb, qae );    
  as_quat_mul( key^.dd, _qb, qbe );    
end;

// --------------------------------------------------------------------------

function as_spline_ease( t, a, b: single ): single;
var
  k, s: single;
begin
  s := a+b;
  if ( s = 0.0 ) then
    begin
      as_spline_ease := t;
      exit;
    end;
  if ( s > 1.0 ) then
    begin
      a := a / s;
      b := b / s;
    end;
  k := 1.0 / ( 2.0 - a - b );
  if ( t < a ) then
    begin
      as_spline_ease := ( k / a ) * sqr( t );
      exit;
    end;
  if ( t < 1.0 - b ) then
    begin
      as_spline_ease := k * ( 2.0 * t - a );
      exit;      
    end;
  t := 1.0 - t;
  as_spline_ease := 1.0 - ( k / b ) * sqr( t );
end;

// --------------------------------------------------------------------------

function as_spline_init( track: as_ptrack ): longint;
var
  curr, keys, last: as_pkey;
begin
  if ( track = nil ) then
    begin
      as_spline_init := as_err_null_pointer;
      exit;
    end;
  if ( track^.keys = nil ) then 
    begin
      as_spline_init := as_err_null_pointer;
      exit;
    end;
  keys := track^.keys;
  last := track^.last;
  if ( keys^.next = nil ) then
    begin
      as_spline_init := as_err_invalid_spline;
      exit;
    end;
  if ( keys^.next^.next <> nil ) then
    begin
      curr := keys^.next;
      while ( curr^.next <> nil ) do
        begin
          as_compderiv( curr^.prev, curr, curr^.next );
          curr := curr^.next;
        end;
      if (( track^.flags and as_trk_loop ) > 0 ) then
        begin
          as_compderivloopfirst( last^.prev, keys, keys^.next, track^.frames );
          as_compderivlooplast( last^.prev, last, keys^.next, track^.frames );
        end else begin
          as_compderivfirst( keys, keys^.next, keys^.next^.next );
          as_compderivlast( last^.prev^.prev, last^.prev, last );
        end;
    end else begin
      as_compderivtwo( keys, keys^.next );
    end;
  as_spline_init := as_err_ok;
end;

// --------------------------------------------------------------------------

function as_spline_initrot( track: as_ptrack ): longint;
var
  curr, keys, last: as_pkey;
begin
  if ( track = nil ) then
    begin
      as_spline_initrot := as_err_null_pointer;
      exit;
    end;
  if ( track^.keys = nil ) then 
    begin
      as_spline_initrot := as_err_null_pointer;
      exit;
    end;
  keys := track^.keys;
  last := track^.last;
  if ( keys^.next = nil ) then
    begin
      as_spline_initrot := as_err_invalid_spline;
      exit;
    end;
  if ( keys^.next^.next <> nil ) then
    begin
      curr := keys^.next;
      while ( curr^.next <> nil ) do
        begin
          as_compab( curr^.prev, curr, curr^.next );
          curr := curr^.next;
        end;
      // [TODO]: rotation loop support.
      as_compab( nil, keys, keys^.next );
      as_compab( last^.prev, last, nil );
    end else begin
      as_compab( nil, keys, keys^.next );
      as_compab( keys, keys^.next, nil );
    end;
  as_spline_initrot := as_err_ok;
end;

// --------------------------------------------------------------------------

function as_spline_getkeyfloat( var out: single; track: as_ptrack; frame: single ): longint;
var
  keys: as_pkey;
  t, t2, t3: single;
  h: array[ 0..3 ] of single;
begin
  if ( frame < 0.0 ) then
    begin
      as_spline_getkeyfloat := as_err_invalid_frame;
      exit;
    end;
  if ( track = nil ) then
    begin
      as_spline_getkeyfloat := as_err_null_pointer;
      exit;
    end;
  if ( track^.keys = nil ) then
    begin
      as_spline_getkeyfloat := as_err_null_pointer;
      exit;
    end;
  if ( frame < track^.last^.frame ) then
    keys := track^.keys else
    keys := track^.last;
  while (( keys^.next <> nil ) and ( frame > keys^.next^.frame )) do
    keys := keys^.next;
  track^.last := keys;
  if (( keys^.next = nil ) or ( frame < keys^.frame )) then       // [BUG] frame ?< keys^.frame
    begin
      out := keys^.val.w;
      as_spline_getkeyfloat := as_err_ok;
      exit;
    end;
  t := ( frame - keys^.frame ) / ( keys^.next^.frame - keys^.frame );
  t := as_spline_ease( t, keys^.easefrom, keys^.easeto );
  t2 := t*t;
  t3 := t2*t;
  h[0] :=  2*t3 - 3*t2 + 1;
  h[1] := t3 - 2*t2 + t;
  h[2] := t3 - t2;
  h[3] := -2*t3 + 3*t2;
  out := h[0] * keys^.val.w + h[1] * keys^.dda + h[2] * keys^.next^.dsa + h[3] * keys^.next^.val.w;
  as_spline_getkeyfloat := as_err_ok;
end;

// --------------------------------------------------------------------------

function as_spline_getkeyvect( var out: as_vector; track: as_ptrack; frame: single ): longint;
var
  keys: as_pkey;
  t, t2, t3: single;
  h: array[ 0..3 ] of single;
begin
  if ( frame < 0.0 ) then
    begin
      as_spline_getkeyvect := as_err_invalid_frame;
      exit;
    end;
  if ( track = nil ) then
    begin
      as_spline_getkeyvect := as_err_null_pointer;
      exit;
    end;
  if ( track^.keys = nil ) then
    begin
      as_spline_getkeyvect := as_err_null_pointer;
      exit;
    end;
  if ( frame < track^.last^.frame ) then
    keys := track^.keys else
    keys := track^.last;
  while (( keys^.next <> nil ) and ( frame > keys^.next^.frame )) do
    keys := keys^.next;
  track^.last := keys;
  if (( keys^.next = nil ) or ( frame < keys^.frame )) then       // [BUG] frame ?< keys^.frame
    begin
      out.x := keys^.val.x;
      out.y := keys^.val.y;
      out.z := keys^.val.z;
      as_spline_getkeyvect := as_err_ok;
      exit;
    end;
  t := ( frame - keys^.frame ) / ( keys^.next^.frame - keys^.frame );
  t := as_spline_ease( t, keys^.easefrom, keys^.easeto );
  t2 := t*t;
  t3 := t2*t;
  h[0] :=  2*t3 - 3*t2 + 1;
  h[1] := t3 - 2*t2 + t;
  h[2] := t3 - t2;
  h[3] := -2*t3 + 3*t2;
  out.x := h[0] * keys^.val.x + h[1] * keys^.ddb + h[2] * keys^.next^.dsb + h[3] * keys^.next^.val.x;
  out.y := h[0] * keys^.val.y + h[1] * keys^.ddc + h[2] * keys^.next^.dsc + h[3] * keys^.next^.val.y;
  out.z := h[0] * keys^.val.z + h[1] * keys^.ddd + h[2] * keys^.next^.dsd + h[3] * keys^.next^.val.z;
  as_spline_getkeyvect := as_err_ok;
end;

// --------------------------------------------------------------------------

function as_spline_getkeyquat( var out: as_quatern; track: as_ptrack; frame: single ): longint;
var
  keys: as_pkey;
  a, b, p, q, q1: as_quatern;
  t, angle, spin: single;
begin
  if ( frame < 0.0 ) then
    begin
      as_spline_getkeyquat := as_err_invalid_frame;
      exit;
    end;
  if ( track = nil ) then
    begin
      as_spline_getkeyquat := as_err_null_pointer;
      exit;
    end;
  if ( track^.keys = nil ) then
    begin
      as_spline_getkeyquat := as_err_null_pointer;
      exit;
    end;
  if ( frame < track^.last^.frame ) then
    keys := track^.keys else
    keys := track^.last;
  while (( keys^.next <> nil ) and ( frame > keys^.next^.frame )) do
    keys := keys^.next;
  track^.last := keys;
  if (( keys^.next = nil ) or ( frame < keys^.frame )) then       // [BUG] frame ?< keys^.frame
    begin
      as_quat_copy( out, keys^.val );
      as_spline_getkeyquat := as_err_ok;
      exit;
    end;
  t := ( frame - keys^.frame ) / ( keys^.next^.frame - keys^.frame );
  t := as_spline_ease( t, keys^.easefrom, keys^.easeto );
  as_quat_copy( a, keys^.qa );
  as_quat_copy( b, keys^.next^.qa );
  angle := keys^.next^.val.w - keys^.val.w;
  if ( angle > 0 ) then
    spin := floor( angle / 6.2831853072 ) else
    spin := ceil( angle / 6.2831853072 );
  // [TODO]: Correct quaternion interpolation.
{} 
  angle := angle - ( 6.2831853072 * spin );
  if ( abs( angle ) > 3.1415926536 ) then
    begin
{}
      as_quat_slerpl( p, a, b, spin, t );
      as_quat_slerpl( q, keys^.dd, keys^.next^.ds, spin, t );
      t := 2.0 * ( 1.0 - t ) * t;
      as_quat_slerpl( q1, p, q, 0, t );
{}
    end else begin
      as_quat_slerp( p, a, b, spin, t );
      as_quat_slerp( q, keys^.dd, keys^.next^.dd, spin, t );
      t := 2.0 * ( 1.0 - t ) * t;
      as_quat_slerp( q1, p, q, 0, t );
    end;
{}
  as_quat_copy( out, q1 );
  as_spline_getkeyquat := as_err_ok;
end;

end.