
unit as_ogl;

// ==========================================================================
//  autospace3d - version 0.90 / o3.o8.2ooo
//  freepascal (clax) keyframing & (opengl) 3d engine - opengl+loader code.
// --------------------------------------------------------------------------
//  copyright (c)2ooo. remage / fresh!mindworkz.
// --------------------------------------------------------------------------

// ==========================================================================

interface

uses
  windows, gl_sl, glu_sl, opengl32,
  as_type, as_vect, as_matr, as_quat, as_splin, as_cam, as_3ds, autosp3d, zfs;

procedure as3d_initialize( resx, resy, resb, flags: longint );

function as3d_loadworld( scene: as_pscene; fname: string ): longint;
function as3d_loadmotion( scene: as_pscene; fname: string ): longint;
function as3d_loadscene( scene: as_pscene; fname: string ): longint;

// ==========================================================================

implementation

// --------------------------------------------------------------------------

procedure as3d_initialize( resx, resy, resb, flags: longint );
begin

  as3d_init( flags );

  glclearcolor( 0.0, 0.0, 0.0, 0.0 );
  glcleardepth( 1.0 );

  gldepthfunc( gl_lequal );
  glenable( gl_depth_test );

  glclear( $00004100 );   // gl_color_buffer_bit or gl_depth_buffer_bit

  glshademodel( gl_smooth );

  glmatrixmode( gl_projection );
  glloadidentity;
  gluperspective( 30.0, single( resx ) / single( resy ), 1.0, 1000.0 );
//glScalef( 1.0, 1.0, 0.01 );

  glmatrixmode( gl_modelview );
  glloadidentity;

end;

// --------------------------------------------------------------------------

function as3d_loadworld( scene: as_pscene; fname: string ): longint;
var
  oldscene: as_pscene;
  err: longint;
  f: file;
begin
  oldscene := as3d_scene;
  // [BUG] Ellenorizni, hogy van-e mar world/keyframe adat...
  scene^.framestart := 0;
  scene^.frameend := 0;
  scene^.frame := 0;
  scene^.world := nil;
  scene^.wtail := nil;
  scene^.keyfr := nil;
  scene^.ktail := nil;
{$I-}
  assign( f, fname );
  reset( f, 1 );
  if ( ioResult <> 0 ) then
    begin
      as3d_loadworld := as_err_file_not_found;
      exit;
    end;
{$I+}
  as3d_setactivescene( scene );
  err := as3d_loadmesh3ds( f );
  close( f );
  if ( err <> as_err_ok ) then
    begin
      as3d_setactivescene( oldscene );
      as3d_freeworld( scene );
      as3d_loadworld := err;
      exit;
    end;

  if (( as3d_flags and as_calcnormal ) > 0 ) then
    as3d_calcnormals;
  as3d_setactivescene( oldscene );
  as3d_loadworld := as_err_ok;
end;

// --------------------------------------------------------------------------

function as3d_loadmotion( scene: as_pscene; fname: string ): longint;
var
  oldscene: as_pscene;
  err: longint;
  f: file;
begin
  oldscene := as3d_scene;
  if ( scene^.world = nil ) then
    begin
      as3d_loadmotion := as_err_no_scene_loaded;
      exit;
    end;
{$I-}
  assign( f, fname );
  reset( f, 1 );
  if ( ioResult <> 0 ) then
    begin
      as3d_loadmotion := as_err_file_not_found;
      exit;
    end;
{$I+}
  as3d_setactivescene( scene );
  err := as3d_loadmotion3ds( f );
  close( f );
  if ( err <> as_err_ok ) then
    begin
      as3d_setactivescene( oldscene );
      as3d_freemotion( scene );
      as3d_loadmotion := err;
      exit;
    end;
  as3d_setframe( 0 );
  as3d_update;
  as3d_setactivescene( oldscene );
  as3d_loadmotion := as_err_ok;
end;

// --------------------------------------------------------------------------

function as3d_loadscene( scene: as_pscene; fname: string ): longint;
var
  err: longint;
begin
  err := as3d_loadworld( scene, fname );
  if ( err <> as_err_ok ) then
    begin
      as3d_loadscene := err;
      exit;
    end;
  as3d_loadscene := as3d_loadmotion( scene, fname );
end;

end.