
unit as_cam;

// ==========================================================================
//  autospace3d - version 0.90 / o1.o8.2ooo
//  freepascal (clax) keyframing & (opengl) 3d engine - camera math.
// --------------------------------------------------------------------------
//  copyright (c)2ooo. remage / fresh!mindworkz.
// --------------------------------------------------------------------------
//  *fov = 15.0 / lens * 160;

interface

uses 
  math, as_type, as_vect, as_matr;

// --------------------------------------------------------------------------

procedure as_cam_update( cam: as_pcamera );

// ==========================================================================

implementation

procedure as_cam_update( cam: as_pcamera );
var
  c, pivot: as_vector;
  mat: as_matrix;
  tanfov, focus, ax, ay, az: single;
  sinx, siny, sinz, cosx, cosy, cosz: single;
begin
  as_matr_identity( mat );
  as_vect_negate( pivot, cam^.position );
  as_vect_sub( c, cam^.target, cam^.position );
  focus := as_vect_length( c );
{ 
  tanfov := tan( cam^.fov / 360 * 3.1415926536 );
  cam^.perspx := 0.5 / tanfov;
  cam^.perspy := 0.5 / tanfov / cam^.aspectratio;
} 
  ax := -arctan2( c.x, c.z );
  ay := arcsin( c.y / focus );
  az := -cam^.roll * 3.1415926536 / 180;
  sinx := sin( ax );   
  siny := sin( ay );   
  sinz := sin( az );
  cosx := cos( ax );   
  cosy := cos( ay );   
  cosz := cos( az );
  
  mat[ 0, 0 ] :=  sinx * siny * sinz + cosx * cosz;
  mat[ 0, 1 ] :=  cosy * sinz;
  mat[ 0, 2 ] :=  sinx * cosz - cosx * siny * sinz;
  mat[ 1, 0 ] :=  sinx * siny * cosz - cosx * sinz;
  mat[ 1, 1 ] :=  cosy * cosz;
  mat[ 1, 2 ] := -cosx * siny * cosz - sinx * sinz;
  mat[ 2, 0 ] := -sinx * cosy;
  mat[ 2, 1 ] :=  siny;
  mat[ 2, 2 ] :=  cosx * cosy;

  as_matr_pretrans( cam^.matrix, mat, pivot );
  
end;

end.