
// ==========================================================================
//  _MAIN.FP - Main FreePascal Code.
//    Copyright (c)2ooo. Remage / Fresh!mindworkz.
// --------------------------------------------------------------------------

unit Aardbei;

{$APPTYPE GUI}
{$DEFINE Win32}

interface

uses
  Windows, GL_Sl, GLu_Sl, OpenGL32, p3d_type, p3d,
  as_type, as_vect, as_matr, as_quat, as_cam, as_splin, as_3ds, autosp3d, as_ogl;

procedure InitAardbeiSphere;
procedure DrawAardbeiSphere( Obj: as_pobject; timer, size,s: single );

var
  Obj, Ob: as_pobject;
  Cam: as_pCamera;
  Node, Nod: as_pwnode;
  nyikk: longint;


implementation

// --------------------------------------------------------------------------

var
  Tmp: string;
  pScene1: as_pscene;


// --------------------------------------------------------------------------

procedure asErr( val: longint );
var
  Tmp: string;
begin
  if ( val <> as_err_ok ) then
    begin
      Str( val, Tmp );
      Tmp := 'AutoSpace3D Error (#' + Tmp + '):' + #13 + as3d_geterror( val ) + #0;
      MessageBox( 0, pchar( Addr( Tmp[1] )), 'Error...', MB_ICONERROR or MB_OK );
      postquitmessage( 0 );
    end;
end;

// --------------------------------------------------------------------------

procedure InitAardbeiSphere;
begin

// as3d_initialize( _ResX, _ResY, _ResB, as_hierarchy + as_calcnormal + as_transform );

  glclearcolor( 0.0, 0.0, 0.0, 0.0 );
  glcleardepth( 1.0 );

  gldepthfunc( gl_less );
  glenable( gl_depth_test );

  glclear( $00004100 );   // gl_color_buffer_bit or gl_depth_buffer_bit

  glshademodel( gl_smooth );

  glmatrixmode( gl_projection );
  glloadidentity;
  gluperspective( 45.0, 4/3, 1.0, 1000.0 );

  glmatrixmode( gl_modelview );
  glloadidentity;

  p3D_loadtextureRAW( 'rondany.raw', nyikk );

  asErr( as3d_allocscene( pScene1 ));
  asErr( as3d_loadscene( pScene1, 'Gomb.3DS' ));

{ as3d_debugworld; }

  as3d_calcnormals;

  asErr( as3d_setactivescene( pScene1 ));
  asErr( as3d_byname( Node, 'Camera01' ));
  Cam := as_pCamera( Node^.Obj );
  asErr( as3d_setactivecamera( nil ));

  asErr( as3d_byname( Node, 'GeoSphere0' ));
  Obj := as_pObject( Node^.Obj );

end;

// --------------------------------------------------------------------------


const
  RND = 4;
  Rand: array[ 0..RND-1, 0..2 ] of single =
    (( 0.476, 0.572, 0.324 ),
     ( 0.247, 0.254, 0.723 ),
     ( 0.525, 0.760, 0.073 ),
     ( 0.728, 0.284, 0.369 ));

var
  randvect: array[ 0..RND-1 ] of as_vector;
  sinx, siny, sinz, cosx, cosy, cosz, ax, ay, az: single;
  nor, tmp1, tmp2, nor1, nor2: as_vector;
  fl: float;

procedure AardbeiInterpolate( var Out: as_vector; in1, in2: as_vector; val1, val2: single );
begin

  if ( val1 = val2 ) then exit;

  Out.x := in1.x + ( in2.x - in1.x ) * ( val1 - 1.0 ) / ( val1 - val2 );
  Out.y := in1.y + ( in2.y - in1.y ) * ( val1 - 1.0 ) / ( val1 - val2 );
  Out.z := in1.z + ( in2.z - in1.z ) * ( val1 - 1.0 ) / ( val1 - val2 );

end;

procedure DrawAardbeiSphere( Obj: as_pobject; timer, size,s: single );
var
  r, i, j: longint;
begin

  for r := 0 to RND-1 do
    begin

      sinx := sin( timer * rand[ r, 0 ] );
      siny := sin( timer * rand[ r, 1 ] );
      sinz := sin( timer * rand[ r, 2 ] );
      cosx := cos( timer * rand[ r, 0 ] );
      cosy := cos( timer * rand[ r, 1 ] );
      cosz := cos( timer * rand[ r, 2 ] );

      randvect[ r ].x := sinx * siny * sinz + cosx * cosz;
      randvect[ r ].y :=s*cosy * sinz;
      randvect[ r ].z := sinx * cosz - cosx * siny * sinz;

    end;

  for i := 0 to obj^.numverts-1 do
    begin

      obj^.verts[i].vert.y := -obj^.verts[i].vert.y;
      as_vect_normalize( nor, obj^.verts[i].vert );
      obj^.verts[i].pvert.x := 0;

      for r := 0 to RND-1 do
        begin
          fl := size * as_vect_dot( nor, randvect[r] );
          if ( fl > 0.0 ) then
            obj^.verts[i].pvert.x += fl;
        end;

    end;

  for i := 0 to obj^.numfaces-1 do
    begin

      j := 0;
      if ( Obj^.Faces[i].pA^.pVert.x > 1.0 ) then j := j or 1;
      if ( Obj^.Faces[i].pB^.pVert.x > 1.0 ) then j := j or 2;
      if ( Obj^.Faces[i].pC^.pVert.x > 1.0 ) then j := j or 4;

      glColor3f( 0.5 - 0.4 * Obj^.Faces[i].Norm.z, 0.5 - 0.4 * Obj^.Faces[i].Norm.z, 0.5 - 0.4 * Obj^.Faces[i].Norm.z );

      case ( J ) of
        $1: begin

              AardbeiInterpolate( Tmp1, Obj^.Faces[i].pA^.Vert, Obj^.Faces[i].pB^.Vert, Obj^.Faces[i].pA^.pVert.x, Obj^.Faces[i].pB^.pVert.x );
              AardbeiInterpolate( Tmp2, Obj^.Faces[i].pA^.Vert, Obj^.Faces[i].pC^.Vert, Obj^.Faces[i].pA^.pVert.x, Obj^.Faces[i].pC^.pVert.x );
              AardbeiInterpolate( Nor1, Obj^.Faces[i].pA^.Norm, Obj^.Faces[i].pB^.Norm, Obj^.Faces[i].pA^.pVert.x, Obj^.Faces[i].pB^.pVert.x );
              AardbeiInterpolate( Nor2, Obj^.Faces[i].pA^.Norm, Obj^.Faces[i].pC^.Norm, Obj^.Faces[i].pA^.pVert.x, Obj^.Faces[i].pC^.pVert.x );

              glBegin( GL_TRIANGLES );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pA^.Norm.x, Obj^.Faces[i].pA^.Norm.y );
              glVertex3f( Obj^.Faces[i].pA^.Vert.x, Obj^.Faces[i].pA^.Vert.y, Obj^.Faces[i].pA^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x, Tmp1.y, Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x, Tmp2.y, Tmp2.z );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pA^.Norm.x, Obj^.Faces[i].pA^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pA^.Vert.x, 0.6*Obj^.Faces[i].pA^.Vert.y, 0.6*Obj^.Faces[i].pA^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );

              glEnd;

              glBegin( GL_QUADS );

              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x, Tmp1.y, Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x, Tmp2.y, Tmp2.z );

              glEnd;

            end;
        $2: begin

              AardbeiInterpolate( Tmp1, Obj^.Faces[i].pB^.Vert, Obj^.Faces[i].pA^.Vert, Obj^.Faces[i].pB^.pVert.x, Obj^.Faces[i].pA^.pVert.x );
              AardbeiInterpolate( Tmp2, Obj^.Faces[i].pB^.Vert, Obj^.Faces[i].pC^.Vert, Obj^.Faces[i].pB^.pVert.x, Obj^.Faces[i].pC^.pVert.x );
              AardbeiInterpolate( Nor1, Obj^.Faces[i].pB^.Norm, Obj^.Faces[i].pA^.Norm, Obj^.Faces[i].pB^.pVert.x, Obj^.Faces[i].pA^.pVert.x );
              AardbeiInterpolate( Nor2, Obj^.Faces[i].pB^.Norm, Obj^.Faces[i].pC^.Norm, Obj^.Faces[i].pB^.pVert.x, Obj^.Faces[i].pC^.pVert.x );

              glBegin( GL_TRIANGLES );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pB^.Norm.x, Obj^.Faces[i].pB^.Norm.y );
              glVertex3f( Obj^.Faces[i].pB^.Vert.x, Obj^.Faces[i].pB^.Vert.y, Obj^.Faces[i].pB^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x, Tmp1.y, Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x, Tmp2.y, Tmp2.z );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pB^.Norm.x, Obj^.Faces[i].pB^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pB^.Vert.x, 0.6*Obj^.Faces[i].pB^.Vert.y, 0.6*Obj^.Faces[i].pB^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );

              glEnd;

              glBegin( GL_QUADS );

              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x, Tmp1.y, Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x, Tmp2.y, Tmp2.z );

              glEnd;

            end;
        $3: begin

              AardbeiInterpolate( Tmp1, Obj^.Faces[i].pC^.Vert, Obj^.Faces[i].pA^.Vert, Obj^.Faces[i].pC^.pVert.x, Obj^.Faces[i].pA^.pVert.x );
              AardbeiInterpolate( Tmp2, Obj^.Faces[i].pC^.Vert, Obj^.Faces[i].pB^.Vert, Obj^.Faces[i].pC^.pVert.x, Obj^.Faces[i].pB^.pVert.x );
              AardbeiInterpolate( Nor1, Obj^.Faces[i].pC^.Norm, Obj^.Faces[i].pA^.Norm, Obj^.Faces[i].pC^.pVert.x, Obj^.Faces[i].pA^.pVert.x );
              AardbeiInterpolate( Nor2, Obj^.Faces[i].pC^.Norm, Obj^.Faces[i].pB^.Norm, Obj^.Faces[i].pC^.pVert.x, Obj^.Faces[i].pB^.pVert.x );

              glBegin( GL_QUADS );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pA^.Norm.x, Obj^.Faces[i].pA^.Norm.y );
              glVertex3f( Obj^.Faces[i].pA^.Vert.x, Obj^.Faces[i].pA^.Vert.y, Obj^.Faces[i].pA^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x,                   Tmp1.y,                   Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x,                   Tmp2.y,                   Tmp2.z );
              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pB^.Norm.x, Obj^.Faces[i].pB^.Norm.y );
              glVertex3f( Obj^.Faces[i].pB^.Vert.x, Obj^.Faces[i].pB^.Vert.y, Obj^.Faces[i].pB^.Vert.z );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pA^.Norm.x, Obj^.Faces[i].pA^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pA^.Vert.x, 0.6*Obj^.Faces[i].pA^.Vert.y, 0.6*Obj^.Faces[i].pA^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );
              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pB^.Norm.x, Obj^.Faces[i].pB^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pB^.Vert.x, 0.6*Obj^.Faces[i].pB^.Vert.y, 0.6*Obj^.Faces[i].pB^.Vert.z );

              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x, Tmp1.y, Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x, Tmp2.y, Tmp2.z );

              glEnd;

            end;
        $4: begin

              AardbeiInterpolate( Tmp1, Obj^.Faces[i].pC^.Vert, Obj^.Faces[i].pA^.Vert, Obj^.Faces[i].pC^.pVert.x, Obj^.Faces[i].pA^.pVert.x );
              AardbeiInterpolate( Tmp2, Obj^.Faces[i].pC^.Vert, Obj^.Faces[i].pB^.Vert, Obj^.Faces[i].pC^.pVert.x, Obj^.Faces[i].pB^.pVert.x );
              AardbeiInterpolate( Nor1, Obj^.Faces[i].pC^.Norm, Obj^.Faces[i].pA^.Norm, Obj^.Faces[i].pC^.pVert.x, Obj^.Faces[i].pA^.pVert.x );
              AardbeiInterpolate( Nor2, Obj^.Faces[i].pC^.Norm, Obj^.Faces[i].pB^.Norm, Obj^.Faces[i].pC^.pVert.x, Obj^.Faces[i].pB^.pVert.x );

              glBegin( GL_TRIANGLES );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pC^.Norm.x, Obj^.Faces[i].pC^.Norm.y );
              glVertex3f( Obj^.Faces[i].pC^.Vert.x, Obj^.Faces[i].pC^.Vert.y, Obj^.Faces[i].pC^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x, Tmp1.y, Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x, Tmp2.y, Tmp2.z );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pC^.Norm.x, Obj^.Faces[i].pC^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pC^.Vert.x, 0.6*Obj^.Faces[i].pC^.Vert.y, 0.6*Obj^.Faces[i].pC^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );

              glEnd;

              glBegin( GL_QUADS );

              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x, Tmp1.y, Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x, Tmp2.y, Tmp2.z );

              glEnd;

            end;
        $5: begin

              AardbeiInterpolate( Tmp1, Obj^.Faces[i].pB^.Vert, Obj^.Faces[i].pA^.Vert, Obj^.Faces[i].pB^.pVert.x, Obj^.Faces[i].pA^.pVert.x );
              AardbeiInterpolate( Tmp2, Obj^.Faces[i].pB^.Vert, Obj^.Faces[i].pC^.Vert, Obj^.Faces[i].pB^.pVert.x, Obj^.Faces[i].pC^.pVert.x );
              AardbeiInterpolate( Nor1, Obj^.Faces[i].pB^.Norm, Obj^.Faces[i].pA^.Norm, Obj^.Faces[i].pB^.pVert.x, Obj^.Faces[i].pA^.pVert.x );
              AardbeiInterpolate( Nor2, Obj^.Faces[i].pB^.Norm, Obj^.Faces[i].pC^.Norm, Obj^.Faces[i].pB^.pVert.x, Obj^.Faces[i].pC^.pVert.x );

              glBegin( GL_QUADS );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pA^.Norm.x, Obj^.Faces[i].pA^.Norm.y );
              glVertex3f( Obj^.Faces[i].pA^.Vert.x, Obj^.Faces[i].pA^.Vert.y, Obj^.Faces[i].pA^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x,                   Tmp1.y,                   Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x,                   Tmp2.y,                   Tmp2.z );
              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pC^.Norm.x, Obj^.Faces[i].pC^.Norm.y );
              glVertex3f( Obj^.Faces[i].pC^.Vert.x, Obj^.Faces[i].pC^.Vert.y, Obj^.Faces[i].pC^.Vert.z );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pA^.Norm.x, Obj^.Faces[i].pA^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pA^.Vert.x, 0.6*Obj^.Faces[i].pA^.Vert.y, 0.6*Obj^.Faces[i].pA^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );
              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pC^.Norm.x, Obj^.Faces[i].pC^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pC^.Vert.x, 0.6*Obj^.Faces[i].pC^.Vert.y, 0.6*Obj^.Faces[i].pC^.Vert.z );

              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x, Tmp1.y, Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x, Tmp2.y, Tmp2.z );

              glEnd;

            end;
        $6: begin

              AardbeiInterpolate( Tmp1, Obj^.Faces[i].pA^.Vert, Obj^.Faces[i].pB^.Vert, Obj^.Faces[i].pA^.pVert.x, Obj^.Faces[i].pB^.pVert.x );
              AardbeiInterpolate( Tmp2, Obj^.Faces[i].pA^.Vert, Obj^.Faces[i].pC^.Vert, Obj^.Faces[i].pA^.pVert.x, Obj^.Faces[i].pC^.pVert.x );
              AardbeiInterpolate( Nor1, Obj^.Faces[i].pA^.Norm, Obj^.Faces[i].pB^.Norm, Obj^.Faces[i].pA^.pVert.x, Obj^.Faces[i].pB^.pVert.x );
              AardbeiInterpolate( Nor2, Obj^.Faces[i].pA^.Norm, Obj^.Faces[i].pC^.Norm, Obj^.Faces[i].pA^.pVert.x, Obj^.Faces[i].pC^.pVert.x );

              glBegin( GL_QUADS );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pB^.Norm.x, Obj^.Faces[i].pB^.Norm.y );
              glVertex3f( Obj^.Faces[i].pB^.Vert.x, Obj^.Faces[i].pB^.Vert.y, Obj^.Faces[i].pB^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x,                   Tmp1.y,                   Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x,                   Tmp2.y,                   Tmp2.z );
              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pC^.Norm.x, Obj^.Faces[i].pC^.Norm.y );
              glVertex3f( Obj^.Faces[i].pC^.Vert.x, Obj^.Faces[i].pC^.Vert.y, Obj^.Faces[i].pC^.Vert.z );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pB^.Norm.x, Obj^.Faces[i].pB^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pB^.Vert.x, 0.6*Obj^.Faces[i].pB^.Vert.y, 0.6*Obj^.Faces[i].pB^.Vert.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );
              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pC^.Norm.x, Obj^.Faces[i].pC^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pC^.Vert.x, 0.6*Obj^.Faces[i].pC^.Vert.y, 0.6*Obj^.Faces[i].pC^.Vert.z );

              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( Tmp1.x, Tmp1.y, Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z, 0.5 - 0.4 * Nor1.z );
              glTexCoord2f( Nor1.x, Nor1.y );
              glVertex3f( 0.6*Tmp1.x,                   0.6*Tmp1.y,                   0.6*Tmp1.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( 0.6*Tmp2.x,                   0.6*Tmp2.y,                   0.6*Tmp2.z );
              glColor3f( 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z, 0.5 - 0.4 * Nor2.z );
              glTexCoord2f( Nor2.x, Nor2.y );
              glVertex3f( Tmp2.x, Tmp2.y, Tmp2.z );

              glEnd;

            end;
        $7: begin

              glBegin( GL_TRIANGLES );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pA^.Norm.x, Obj^.Faces[i].pA^.Norm.y );
              glVertex3f( Obj^.Faces[i].pA^.Vert.x, Obj^.Faces[i].pA^.Vert.y, Obj^.Faces[i].pA^.Vert.z );
              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pB^.Norm.x, Obj^.Faces[i].pB^.Norm.y );
              glVertex3f( Obj^.Faces[i].pB^.Vert.x, Obj^.Faces[i].pB^.Vert.y, Obj^.Faces[i].pB^.Vert.z );
              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pC^.Norm.x, Obj^.Faces[i].pC^.Norm.y );
              glVertex3f( Obj^.Faces[i].pC^.Vert.x, Obj^.Faces[i].pC^.Vert.y, Obj^.Faces[i].pC^.Vert.z );

              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pA^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pA^.Norm.x, Obj^.Faces[i].pA^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pA^.Vert.x, 0.6*Obj^.Faces[i].pA^.Vert.y, 0.6*Obj^.Faces[i].pA^.Vert.z );
              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pB^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pB^.Norm.x, Obj^.Faces[i].pB^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pB^.Vert.x, 0.6*Obj^.Faces[i].pB^.Vert.y, 0.6*Obj^.Faces[i].pB^.Vert.z );
              glColor3f( 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z, 0.5 - 0.4 * Obj^.Faces[i].pC^.Norm.z );
              glTexCoord2f( Obj^.Faces[i].pC^.Norm.x, Obj^.Faces[i].pC^.Norm.y );
              glVertex3f( 0.6*Obj^.Faces[i].pC^.Vert.x, 0.6*Obj^.Faces[i].pC^.Vert.y, 0.6*Obj^.Faces[i].pC^.Vert.z );

              glEnd;

            end;
        end;

    end;

  as_vect_copy( obj^.verts[i].pvert, obj^.verts[i].vert );

end;

(*
      Node := as3d_scene^.world;
      while ( Node <> nil ) do
        begin
          if ( Node^.typ = as_obj_object ) then
            begin
              Obj := as_pobject( Node^.obj );
              glLoadIdentity;
              gluLookAt( (2.0+0.3*sin(Frame*0.02))*Cam^.Position.x, (2.0+0.3*sin(Frame*0.02))*Cam^.Position.y, (2.0+0.3*sin(Frame*0.02))*Cam^.Position.z, Cam^.Target.x, Cam^.Target.y, Cam^.Target.z, 0.0, 1.0, 0.0 );
              if ( Obj^.FName = 'GeoSphere0' ) then
                DrawAardbeiSphere( Obj, Frame*0.13, 0.8 );
            end;
          Node := Node^.next;
        end;
*)

end.