procedure initPart5;
begin
  Frame := 0;
  randseed := 1;

  for i := 0 to 7 do
    as_vect_make( tunvec[i].vec, random(512)-255, random(512)-255, random(512)-255 );

  for i := 0 to 7 do
    begin
      as_vect_sub( tunvec[(i+1)and 7].ease, tunvec[(i+2)and 7].vec, tunvec[i].vec );
      as_vect_scale( tunvec[(i+1)and 7].ease, tunvec[(i+1)and 7].ease, 1/6 );
    end;

  for i := 0 to 127 do
    begin

      tunnel[i].vec.x := bezier( (i and 15)/16, tunvec[i div 16].vec.x, tunvec[i div 16].ease.x, tunvec[((i div 16)+1) and 7].ease.x, tunvec[((i div 16)+1) and 7].vec.x );
      tunnel[i].vec.y := bezier( (i and 15)/16, tunvec[i div 16].vec.y, tunvec[i div 16].ease.y, tunvec[((i div 16)+1) and 7].ease.y, tunvec[((i div 16)+1) and 7].vec.y );
      tunnel[i].vec.z := bezier( (i and 15)/16, tunvec[i div 16].vec.z, tunvec[i div 16].ease.z, tunvec[((i div 16)+1) and 7].ease.z, tunvec[((i div 16)+1) and 7].vec.z );

    end;

  for i := 0 to 127 do
    begin

      as_vect_sub( tunnel[(i+1)and 127].ease, tunnel[(i+2)and 127].vec, tunnel[i].vec );
      as_vect_scale( tunnel[(i+1)and 127].ease, tunnel[(i+1)and 127].ease, 1/6 );

      as_vect_cross( tunnel[(i+1) and 127].xadd, tunnel[(i+1) and 127].ease, fel );
      as_vect_normalize( tunnel[(i+1) and 127].xadd, tunnel[(i+1) and 127].xadd );

      as_vect_cross( tunnel[(i+1) and 127].yadd, tunnel[(i+1) and 127].xadd, tunnel[(i+1) and 127].ease );
      as_vect_normalize( tunnel[(i+1) and 127].yadd, tunnel[(i+1) and 127].yadd );

    end;
end;

procedure part5;
begin
  glClearColor( 0.0, 0.0, 0.0, 0.0 );
  glClear( $4100 ); // GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT

  glBindTexture( GL_TEXTURE_2D, nyikk2 );
  glEnable( GL_TEXTURE_2D );
  glcolor4f(1,1,1,1);

  Frame:=timerGet( 1000 ) / 150;
{ Frame+=0.17; }

  glmatrixmode( gl_projection );
  glloadidentity;
  gluperspective( 30.0,4.0/3.0,0.1,1000.0 );

  glMatrixMode( GL_MODELVIEW );
  glLoadIdentity;

  i := trunc( frame ) and 127;
  j := (i+1) and 127;

  camp.x := bezier( frac(Frame), tunnel[i].vec.x, tunnel[i].ease.x, tunnel[j].ease.x, tunnel[j].vec.x );
  camp.y := bezier( frac(Frame), tunnel[i].vec.y, tunnel[i].ease.y, tunnel[j].ease.y, tunnel[j].vec.y );
  camp.z := bezier( frac(Frame), tunnel[i].vec.z, tunnel[i].ease.z, tunnel[j].ease.z, tunnel[j].vec.z );

  i := (i+3) and 127;
  j := (j+3) and 127;
  camt.x := bezier( frac(Frame), tunnel[i].vec.x, tunnel[i].ease.x, tunnel[j].ease.x, tunnel[j].vec.x );
  camt.y := bezier( frac(Frame), tunnel[i].vec.y, tunnel[i].ease.y, tunnel[j].ease.y, tunnel[j].vec.y );
  camt.z := bezier( frac(Frame), tunnel[i].vec.z, tunnel[i].ease.z, tunnel[j].ease.z, tunnel[j].vec.z );

  gluLookAt( camp.x, camp.y, camp.z, camt.x, camt.y, camt.z, 0, 1, 0 );

  // Draw.

  glDisable( GL_BLEND );
  glDepthFunc( GL_LESS );

  glBegin( GL_QUADS );

  for i := trunc( Frame )-2 to trunc( Frame )+8 do
    begin

      for j := 0 to 15 do
        begin

          glColor3f( (8+Frame-i)/7, (8+Frame-i)/7, (8+Frame-i)/7 );

          glTexCoord2f( j/16 + Frame/48, i/16 + Frame/64 );
          glVertex3f( tunnel[( i ) and 127].vec.x + 3*tunnel[( i ) and 127].xadd.x*sin(j*pi/8) + 3*tunnel[( i ) and 127].yadd.x*cos(j*pi/8),
                      tunnel[( i ) and 127].vec.y + 3*tunnel[( i ) and 127].xadd.y*sin(j*pi/8) + 3*tunnel[( i ) and 127].yadd.y*cos(j*pi/8),
                      tunnel[( i ) and 127].vec.z + 3*tunnel[( i ) and 127].xadd.z*sin(j*pi/8) + 3*tunnel[( i ) and 127].yadd.z*cos(j*pi/8) );

          glColor3f( (7+Frame-i)/7, (7+Frame-i)/7, (7+Frame-i)/7 );

          glTexCoord2f( j/16 + Frame/48, (i+1)/16 + Frame/64 );
          glVertex3f( tunnel[(i+1) and 127].vec.x + 3*tunnel[(i+1) and 127].xadd.x*sin(j*pi/8) + 3*tunnel[(i+1) and 127].yadd.x*cos(j*pi/8),
                      tunnel[(i+1) and 127].vec.y + 3*tunnel[(i+1) and 127].xadd.y*sin(j*pi/8) + 3*tunnel[(i+1) and 127].yadd.y*cos(j*pi/8),
                      tunnel[(i+1) and 127].vec.z + 3*tunnel[(i+1) and 127].xadd.z*sin(j*pi/8) + 3*tunnel[(i+1) and 127].yadd.z*cos(j*pi/8) );

          glColor3f( (7+Frame-i)/7, (7+Frame-i)/7, (7+Frame-i)/7 );

          glTexCoord2f( (j+1)/16 + Frame/48, (i+1)/16 + Frame/64 );
          glVertex3f( tunnel[(i+1) and 127].vec.x + 3*tunnel[(i+1) and 127].xadd.x*sin((j+1)*pi/8) + 3*tunnel[(i+1) and 127].yadd.x*cos((j+1)*pi/8),
                      tunnel[(i+1) and 127].vec.y + 3*tunnel[(i+1) and 127].xadd.y*sin((j+1)*pi/8) + 3*tunnel[(i+1) and 127].yadd.y*cos((j+1)*pi/8),
                      tunnel[(i+1) and 127].vec.z + 3*tunnel[(i+1) and 127].xadd.z*sin((j+1)*pi/8) + 3*tunnel[(i+1) and 127].yadd.z*cos((j+1)*pi/8) );

          glColor3f( (8+Frame-i)/7, (8+Frame-i)/7, (8+Frame-i)/7 );

          glTexCoord2f( (j+1)/16 + Frame/48, i/16 + Frame/64 );
          glVertex3f( tunnel[( i ) and 127].vec.x + 3*tunnel[( i ) and 127].xadd.x*sin((j+1)*pi/8) + 3*tunnel[( i ) and 127].yadd.x*cos((j+1)*pi/8),
                      tunnel[( i ) and 127].vec.y + 3*tunnel[( i ) and 127].xadd.y*sin((j+1)*pi/8) + 3*tunnel[( i ) and 127].yadd.y*cos((j+1)*pi/8),
                      tunnel[( i ) and 127].vec.z + 3*tunnel[( i ) and 127].xadd.z*sin((j+1)*pi/8) + 3*tunnel[( i ) and 127].yadd.z*cos((j+1)*pi/8) );

        end;
    end;

  glEnd;

  glBlendFunc( GL_ONE, GL_ONE );
  glEnable( GL_BLEND );

  glBegin( GL_QUADS );

  for i := trunc( Frame )-2 to trunc( Frame )+8 do
    begin

      for j := 0 to 15 do
        begin

          glColor3f( (8+Frame-i)/7, (8+Frame-i)/7, (8+Frame-i)/7 );

          glTexCoord2f( j/16 - Frame/47, i/16 + Frame/63 );
          glVertex3f( tunnel[( i ) and 127].vec.x + 2*tunnel[( i ) and 127].xadd.x*sin(j*pi/8) + 2*tunnel[( i ) and 127].yadd.x*cos(j*pi/8),
                      tunnel[( i ) and 127].vec.y + 2*tunnel[( i ) and 127].xadd.y*sin(j*pi/8) + 2*tunnel[( i ) and 127].yadd.y*cos(j*pi/8),
                      tunnel[( i ) and 127].vec.z + 2*tunnel[( i ) and 127].xadd.z*sin(j*pi/8) + 2*tunnel[( i ) and 127].yadd.z*cos(j*pi/8) );

          glColor3f( (7+Frame-i)/7, (7+Frame-i)/7, (7+Frame-i)/7 );

          glTexCoord2f( j/16 - Frame/47, (i+1)/16 + Frame/63 );
          glVertex3f( tunnel[(i+1) and 127].vec.x + 2*tunnel[(i+1) and 127].xadd.x*sin(j*pi/8) + 2*tunnel[(i+1) and 127].yadd.x*cos(j*pi/8),
                      tunnel[(i+1) and 127].vec.y + 2*tunnel[(i+1) and 127].xadd.y*sin(j*pi/8) + 2*tunnel[(i+1) and 127].yadd.y*cos(j*pi/8),
                      tunnel[(i+1) and 127].vec.z + 2*tunnel[(i+1) and 127].xadd.z*sin(j*pi/8) + 2*tunnel[(i+1) and 127].yadd.z*cos(j*pi/8) );

          glColor3f( (7+Frame-i)/7, (7+Frame-i)/7, (7+Frame-i)/7 );

          glTexCoord2f( (j+1)/16 - Frame/47, (i+1)/16 + Frame/63 );
          glVertex3f( tunnel[(i+1) and 127].vec.x + 2*tunnel[(i+1) and 127].xadd.x*sin((j+1)*pi/8) + 2*tunnel[(i+1) and 127].yadd.x*cos((j+1)*pi/8),
                      tunnel[(i+1) and 127].vec.y + 2*tunnel[(i+1) and 127].xadd.y*sin((j+1)*pi/8) + 2*tunnel[(i+1) and 127].yadd.y*cos((j+1)*pi/8),
                      tunnel[(i+1) and 127].vec.z + 2*tunnel[(i+1) and 127].xadd.z*sin((j+1)*pi/8) + 2*tunnel[(i+1) and 127].yadd.z*cos((j+1)*pi/8) );

          glColor3f( (8+Frame-i)/7, (8+Frame-i)/7, (8+Frame-i)/7 );

          glTexCoord2f( (j+1)/16 - Frame/47, i/16 + Frame/63 );
          glVertex3f( tunnel[( i ) and 127].vec.x + 2*tunnel[( i ) and 127].xadd.x*sin((j+1)*pi/8) + 2*tunnel[( i ) and 127].yadd.x*cos((j+1)*pi/8),
                      tunnel[( i ) and 127].vec.y + 2*tunnel[( i ) and 127].xadd.y*sin((j+1)*pi/8) + 2*tunnel[( i ) and 127].yadd.y*cos((j+1)*pi/8),
                      tunnel[( i ) and 127].vec.z + 2*tunnel[( i ) and 127].xadd.z*sin((j+1)*pi/8) + 2*tunnel[( i ) and 127].yadd.z*cos((j+1)*pi/8) );

        end;
    end;

  glEnd;

end;