// === tentacleball.

var
  space82: longint;

function veclength( vec: p3d_vector ): single;
begin
  veclength := sqrt( sqr( vec.x ) + sqr( vec.y ) + sqr( vec.z ));
end;

procedure calctentacleball( dst, src: p3d_object; timer, dist: single );

const
  RND = 4;
  Rand: array[ 0..RND-1, 0..2 ] of single =
    (( 0.476, 0.572, 0.324 ),
     ( 0.247, 0.254, 0.723 ),
     ( 0.525, 0.760, 0.073 ),
     ( 0.728, 0.284, 0.369 ));

var
  i: integer;
  sinx, siny, sinz, cosx, cosy, cosz, tim: single;
  mat: array[ 0..2, 0..2 ] of single;
  fl: float;

begin

  for i := 0 to src.vertices-1 do
    begin

      tim := timer - dist * veclength( src.vertex[i] );

      sinx := sin( tim * rand[ 0, 0 ] );
      cosx := cos( tim * rand[ 0, 0 ] );

      siny := sin( tim * rand[ 1, 0 ] );
      cosy := cos( tim * rand[ 1, 0 ] );

      sinz := sin( tim * rand[ 2, 0 ] );
      cosz := cos( tim * rand[ 2, 0 ] );

      mat[ 0, 0 ] :=  sinx * siny * sinz + cosx * cosz;
      mat[ 0, 1 ] :=  cosy * sinz;
      mat[ 0, 2 ] :=  sinx * cosz - cosx * siny * sinz;
      mat[ 1, 0 ] :=  sinx * siny * cosz - cosx * sinz;
      mat[ 1, 1 ] :=  cosy * cosz;
      mat[ 1, 2 ] := -cosx * siny * cosz - sinx * sinz;
      mat[ 2, 0 ] := -sinx * cosy;
      mat[ 2, 1 ] :=  siny;
      mat[ 2, 2 ] :=  cosx * cosy;

      dst.vertex[i].x :=   0.307 + 0.5 * ( mat[0,0] * ( src.vertex[i].x - 0.307 ) + mat[0,1] * ( src.vertex[i].y + 0.045 ) + mat[0,2] * ( src.vertex[i].z - 160.253 ));
      dst.vertex[i].y :=  -0.045 + 0.5 * ( mat[1,0] * ( src.vertex[i].x - 0.307 ) + mat[1,1] * ( src.vertex[i].y + 0.045 ) + mat[1,2] * ( src.vertex[i].z - 160.253 ));
      dst.vertex[i].z := 160.253 + 0.5 * ( mat[2,0] * ( src.vertex[i].x - 0.307 ) + mat[2,1] * ( src.vertex[i].y + 0.045 ) + mat[2,2] * ( src.vertex[i].z - 160.253 ));
                           { SCALE ^^^ }

    end;
end;

// === eddig.

procedure part4;
begin
  timer:=(timerGet( 600 ) - 78000) / 212;
  if ( timer < 0 ) then timer:=0;
  p3D_ambient(0,0,0);
  p3D_lighton:= true;
  p3D_lightpos(0.0,0.4946,69.5844);
  scene4.obj[11].reclight := false;
  scene4.obj[11].render := false;
  // === tentacleball.
  scene4.obj[12].render := false;
  calctentacleball( scene4.obj[12], scene6.obj[0], timer/2, 0.03 );
  // === eddig.

  if ( erosegalfa <= 1.0 ) then
    begin
      erosegalfa:=( timerGet( 1000 ) - 80000 ) / 25000;
      if ( erosegalfa > 1 ) then erosegalfa:=1;
      p3D_lightattr(1,1,1,(1-erosegalfa)*1000+1300);
    end;

  glDisable( GL_BLEND );
  glDepthMask( True );
  scalex:= 1;scaley :=1;scalez:=1;
  p3d_renderscene(scene4,timer);
  p3d_clearzbuffer:= False;

  p3d_rendersceneobject(scene4,timer,11,erosegalfa);
  tmp:=scene4.material[ scene4.obj[ 11 ].material ].texture;
  scalex:= 0.95; scaley:= 0.95; scalez:= 0.95;
  scene4.material[ scene4.obj[ 11 ].material ].texture:=erosnappal;
  glEnable( GL_BLEND );
  glDepthMask( False );
  glBlendfunc( GL_Src_Alpha,GL_One_minus_src_Alpha );
  p3d_rendersceneobject(scene4,timer,11,1-erosegalfa);
  scene4.material[ scene4.obj[ 11 ].material ].texture:=tmp;
  // === tentacleball.
  tmp := scene4.material[scene4.obj[12].material].texture;
  scene4.material[scene4.obj[12].material].texture := space82;

  glEnable( GL_BLEND );
  glDepthMask( False );
  p3d_rendersceneobject( scene4, timer, 12, 0.4 );
  glDepthMask( TRUE );
  glDisable( GL_BLEND );

  scene4.material[scene4.obj[12].material].texture := tmp;
  // === eddig.
  p3d_clearzbuffer:= True;
end;