const
  RND = 4;
  Rand: array[ 0..RND-1, 0..2 ] of single =
    (( 0.476, 0.572, 0.324 ),
     ( 0.247, 0.254, 0.723 ),
     ( 0.525, 0.760, 0.073 ),
     ( 0.728, 0.284, 0.369 ));

var
  sphere38: longint;

function MaxNoiseFunc( t, i: longint; Timer1, Timer2: single ): Single;
begin
  MaxNoiseFunc := Sin( 0.1*Timer1*Rand[i,t] ) * ( Sin( 0.09*Timer1*Rand[i,(t+1) mod 3] + Sin( 0.07*Timer2*Rand[i,(t+2) mod 3] )));
end;

function MaxNoise( t: longint; Timer1, Timer2: single ): Single;
var
  Fl: single;
  i: longint;
begin
  Fl := 0.0;
  for i := 0 to RND-1 do
    Fl := Fl + MaxNoiseFunc( t, i, (i+1)*Timer1, (i+1)*Timer2 ) / (2 shl i);
  MaxNoise := Fl;
end;

const
  Scal: single = 2.3;

procedure CalcMaxNoiseSphere( dst, src: p3d_object; timer, scale: single );
var
  i: longint;
begin
  for i := 0 to src.vertices-1 do
    begin
      dst.vertex[i].x := scale * maxnoise( 0, timer + scal * src.vertex[i].x, timer + scal * src.vertex[i].y ) + src.vertex[i].x;
      dst.vertex[i].y := scale * maxnoise( 1, timer + scal * src.vertex[i].y, timer + scal * src.vertex[i].z ) + src.vertex[i].y;
      dst.vertex[i].z := scale * maxnoise( 2, timer + scal * src.vertex[i].z, timer + scal * src.vertex[i].x ) + src.vertex[i].z;
    end;
end;

procedure Part6;
begin
  p3D_ambient(0,0,0);
  p3D_lighton:= true;
  p3D_lightpos( -0.6414,0.0000,159.3159 );
  p3D_lightattr(1,1,1,700);
  scene7.obj[15].reclight:=false;
  scene7.obj[12].render:=false;
  scene7.obj[13].render:=false;
  scene7.obj[14].render:=false;
  calcmaxnoisesphere( scene7.obj[12], scene8.obj[0], timer*12, 18.0 );
  
  glDisable( GL_BLEND );
  glDepthMask( True );

  p3d_renderscene(scene7,timer);
  
  tmp := scene7.material[scene7.obj[12].material].texture;
  scene7.material[scene7.obj[12].material].texture := sphere38;

  glBlendfunc( GL_Src_Alpha,GL_One_minus_src_Alpha );
  glEnable( GL_BLEND );
  glDepthMask( False );
  p3d_clearzbuffer:=false;
  p3d_rendersceneobject( scene7, timer, 12, 0.4 );
  p3d_clearzbuffer:=true;
  glDepthMask( TRUE );
  glDisable( GL_BLEND );

  scene7.material[scene7.obj[12].material].texture := tmp;
end;